package net.souko105.flashserver.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * pX֌W̃[eBeB
 * RequestURI = contextpath + servletpath + pathinfo 
 * @author AKatayama
 */
public class PathUtils
{
    private PathUtils()
    {
        super();
    }
    public static URL[] archivePathString2URLs(String paths) throws MalformedURLException
    {
    	StringTokenizer token = new StringTokenizer(paths,";",false);
    	List urlList = new ArrayList();
    	while(token.hasMoreTokens())
    	{
    		String path = token.nextToken();
    		urlList.add(new URL("file:///"+path));
    	}
    	return (URL[])urlList.toArray(new URL[]{});
    }
    public static String createArchiveClassPathString(String targetDir) throws MalformedURLException
    {
    	URL[] urls = createArchiveClassPaths(targetDir);
    	if(urls == null)
    		return null;
    	else
    	{
    		StringBuffer path = new StringBuffer();
    		for(int i = 0;i < urls.length;i++)
    		{
				String libPath = urls[i].toString();
				if(libPath.startsWith("file:/"))
					libPath = libPath.substring("file:/".length());

    			if(i == 0)
    				path.append(libPath);
    			else
    				path.append(";"+libPath);
    		}
    		return path.toString();
    	}
    }
    public static URL[] createArchiveClassPaths(String targetDir) throws MalformedURLException
    {
    	File libDir = new File(targetDir);
    	if(!libDir.exists())
    		return null;

    	List urlList = new ArrayList();

        
        File[] libs = libDir.listFiles(new FileFilter(){
            public boolean accept(File pathname){
                if(pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip"))
                    return true;
                else
                    return false;
            }});
        if(libs != null)
        {
	        for(int i = 0;i < libs.length;i++)
	        {
	            String libPath = libs[i].getAbsolutePath();
	            libPath = IOUtils.replaceFileSeparator(libPath);
	           	urlList.add(new URL("file:///"+libPath));
	        }
        }
        
        File[] dirs = libDir.listFiles();
        if(dirs != null)
        {
        	for(int i = 0;i < dirs.length;i++)
        	{
        		if(dirs[i].isDirectory())
        		{
        			URL[] urls = createArchiveClassPaths(dirs[i].getAbsolutePath());
        			if(urls != null)
        			{
        				for(int j = 0;j < urls.length;j++)
        					urlList.add(urls[j]);
        			}
        		}	
        	}
        }
        
        return (URL[])urlList.toArray(new URL[]{});
    }
    /**
     * NGXgURĨReLXgpXԂ܂B
     * @param requestURI
     * @return contextPath
     */
    public static String getContextPath(String requestURI)
    {
        if(requestURI == null)
            return null;

        if(requestURI.startsWith("/"))
        {
            if(requestURI.indexOf("/",1) != -1)
            {
                String contextPath = requestURI.substring(0,requestURI.indexOf("/",1));
                return contextPath;
            }
            return requestURI;
        }
        return null;
    }
    /**
     * NGXgURĨReLXgpXȊO̕Ԃ܂B
     * resoucePath = servletpath + pathinfo
     * @param requestURI
     * @return resourcePath
     */
    public static String getResourcePath(String requestURI)
    {
        if(requestURI == null)
            return null;
        
        if(requestURI.startsWith("/") && requestURI.length() > 1 && requestURI.indexOf("/",1) >=1)
        {
	        String servletPath = requestURI.substring(requestURI.indexOf("/",1),requestURI.length());
	        return servletPath;
        }
        return null;
    }
    /**
     * pXƃpXp^[̃}b`Os܂B
     * @param pattern
     * @param resourcePath
     * @return
     */
    public static boolean matchPattern(String pattern,String resourcePath)
    {
        if(pattern == null || resourcePath == null )
            return false;

        if(pattern.equals(resourcePath))
            return true;

        if(pattern.equals("/*"))
            return true;
        
        if(pattern.endsWith("/*"))
        {
            if (pattern.regionMatches(0, resourcePath, 0, pattern.length() - 2)) 
            {
                if (resourcePath.length() == (pattern.length() - 2)) 
                    return true;
                else if (resourcePath.charAt(pattern.length() - 2) == '/')
                    return true;
            }
            return false;
        }

        if(pattern.startsWith("*.")) 
        {            
            int resourceDot = resourcePath.lastIndexOf(".");
            if(resourceDot >= 0)
            {
                String resourceExt = resourcePath.substring(resourceDot,resourcePath.length());
                int patternDot = pattern.indexOf(".");
                String patternExt = pattern.substring(patternDot,pattern.length());
                
                if(resourceExt.equals(patternExt))
                    return true;
                else
                    return false;
            }
        }
        return false;
    }
}
