package net.souko105.flashserver.javaee.webxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * web-app^Õf[^NX
 * @author AKatayama
 */
public class WebAppTag
{
    private List filterList = new ArrayList();
    private List filterMappingList = new ArrayList();
    private List servletList = new ArrayList();
    private List servletMappingList = new ArrayList();
    
    public WebAppTag()
    {
        super();
    }
    public void addFilter(FilterTag filter)
    {
        this.filterList.add(filter);
    }
    public void addFilterMapping(FilterMappingTag mapping)
    {
        this.filterMappingList.add(mapping);
    }
    public List getFilterList()
    {
        return filterList;
    }
    public List getFilterMappingList()
    {
        return filterMappingList;
    }
    public FilterTag findFilter(FilterTag filterName)
    {
        for(Iterator itr = filterList.iterator();itr.hasNext();)
        {
            FilterTag filter = (FilterTag)itr.next();
            if(filter.getFilterName().equals(filterName))
                return filter;
        }
        return null;
    }
    public FilterMappingTag findFiterMapping(String filterName)
    {
        for(Iterator itr = filterMappingList.iterator();itr.hasNext();)
        {
            FilterMappingTag filterMapping = (FilterMappingTag)itr.next();
            if(filterMapping.getFilterName().equals(filterName))
                return filterMapping;
        }
        return null;
    }    
    
    public void addServlet(ServletTag servlet)
    {
        this.servletList.add(servlet);
    }
    public void addServletMapping(ServletMappingTag mapping)
    {
        this.servletMappingList.add(mapping);
    }    
    public List getServletList()
    {
        return servletList;
    }
    public List getServletMappingList()
    {
        return servletMappingList;
    }
    public ServletTag findServlet(String servletName)
    {
        for(Iterator itr = servletList.iterator();itr.hasNext();)
        {
            ServletTag servet = (ServletTag)itr.next();
            if(servet.getServletName().equals(servletName))
                return servet;
        }
        return null;
    }
    public ServletMappingTag findServletMapping(String servletName)
    {
        for(Iterator itr = servletMappingList.iterator();itr.hasNext();)
        {
            ServletMappingTag servetMapping = (ServletMappingTag)itr.next();
            if(servetMapping.getServletName().equals(servletName))
                return servetMapping;
        }
        return null;
    }
}
