package net.souko105.flashserver.javaee.imp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import net.souko105.flashserver.javaee.webxml.FilterMappingTag;
import net.souko105.flashserver.javaee.webxml.FilterTag;
import net.souko105.flashserver.javaee.webxml.ServletMappingTag;
import net.souko105.flashserver.javaee.webxml.ServletTag;
import net.souko105.flashserver.javaee.webxml.WebXml;
import net.souko105.flashserver.util.PathUtils;

/**
 * WebAppNX
 * PWebAvP[VɑT[ubgReLXgA
 * T[ubgAtB^[AwebxmlANX[_[
 * W񂳂Ă܂B
 * WebAppManagerɂǗAReLXgpXL[
 * o܂B 
 * @author AKatayama
 */
public class WebApp {
	
	/** web.xml` */
    private WebXml webXml;
    /** ReLXgpX܂ރ[JtH_̐΃pX */
    private String absoluteContextPath;
    /**  /n܂ReLXgpX */
    private String contextPath;
    /** WebApplicationNX[_[ */
    private WebAppClassLoader webAppClassLoader;
    
    /**ServletContext*/
    private ServletContextImp servletContext;
    /**Servlet Map*/
    private Map servletMap;
    /**Filter Map*/
    private Map filterMap;
    
    WebApp(WebXml webXml,String absoluteContextPath,String contextPath,WebAppClassLoader webAppClassLoader)throws WebAppInitializeException
	{
    	this.webXml = webXml;
    	this.absoluteContextPath = absoluteContextPath;
    	this.contextPath = contextPath;
    	this.webAppClassLoader = webAppClassLoader;	
    	init();
	}
    public String getAbsoluteContextPath()
    {
        return absoluteContextPath;
    }
    public String getContextPath()
    {
        return contextPath;
    }
    public WebAppClassLoader getWebAppClassLoader()
    {
        return webAppClassLoader;
    }
    public WebXml getWebXml()
    {
        return webXml;
    }
    public ServletContext getServletContext()
    {
    	return servletContext;
    }
    
    private void init() throws WebAppInitializeException
	{
    	initServletContext();
    	initServlet();
    	initFilter();
    }    
    private void initServletContext()
    {        
        servletContext = new ServletContextImp();
        servletContext.setAbsoluteContextPath(absoluteContextPath);
        servletContext.setServletContextName(contextPath);
        //TODO set servletcontest init param
    }
    private void initServlet() throws WebAppInitializeException
    {
    	ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webAppClassLoader);
        try
		{
        	List servletList = webXml.getWebApp().getServletList();
	    	for(Iterator servletItr = servletList.iterator();servletItr.hasNext();)
	        {
	    		if(servletMap == null)
	    			servletMap = new HashMap();
	    		
	            ServletTag servletTag = (ServletTag)servletItr.next();                                
	            Servlet servletInstance = (Servlet)createInstance(webAppClassLoader,servletTag.getServletClass());
	            ServletConfig config = createServletConfig(servletTag);
	            try
	            {
	                servletInstance.init(config);
	            }
	            catch(ServletException e)
	            {
	                throw new WebAppInitializeException(e);
	            }
	            servletMap.put(servletTag.getServletName(),servletInstance);
	        }
	    	servletContext.setServletMap(servletMap);
		}
        finally
		{
        	Thread.currentThread().setContextClassLoader(oldClassLoader);
		}        
    }
    private void initFilter() throws WebAppInitializeException
    {
    	ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(webAppClassLoader);
        try
		{
	    	List filterList = webXml.getWebApp().getFilterList();
	        for(Iterator filterItr = filterList.iterator();filterItr.hasNext();)
	        {
	        	if(filterMap == null)
	        		filterMap = new HashMap();
	        	
	            FilterTag filterTag = (FilterTag)filterItr.next();
	                                
	            Filter filterInstance = (Filter)createInstance(webAppClassLoader,filterTag.getFilterClass());
	            FilterConfig config = createFilterConfig(filterTag);
	            try
	            {
	                filterInstance.init(config);
	            }
	            catch(ServletException e)
	            {
	                throw new WebAppInitializeException(e);
	            }
	            filterMap.put(filterTag.getFilterName(),filterInstance);
	        }
		}
        finally
		{
        	Thread.currentThread().setContextClassLoader(oldClassLoader);
		}
    }    
    private Object createInstance(ClassLoader webAppClassLoader,String className) throws WebAppInitializeException
    {
        try
        {            
            Class clazz = webAppClassLoader.loadClass(className);
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e)
        {
            throw new WebAppInitializeException("Class not found. className="+className,e);
        }
        catch (InstantiationException e)
        {
            throw new WebAppInitializeException("Class instantiate fail. className="+className,e);
        }
        catch (IllegalAccessException e)
        {
            throw new WebAppInitializeException("Class access fail. className="+className,e);
        }
    }
    private ServletConfig createServletConfig(ServletTag servletTag)
    {
        ServletConfigImp config = new ServletConfigImp();
        config.setServletContext(servletContext);
        Map initParamMap = servletTag.getInitParamMap();
        for(Iterator paramItr = initParamMap.keySet().iterator();paramItr.hasNext();)
        {
            String paramName = (String)paramItr.next();
            String paramValue = (String)initParamMap.get(paramName);
            config.addInitParameter(paramName,paramValue);
        }
        config.setServletName(servletTag.getServletName());
        return config;
    }
    private FilterConfig createFilterConfig(FilterTag filterTag)
    {
        FilterConfigImp config = new FilterConfigImp();
        config.setServletContext(servletContext);
        Map initParamMap = filterTag.getInitParamMap();
        for(Iterator paramItr = initParamMap.keySet().iterator();paramItr.hasNext();)
        {
            String paramName = (String)paramItr.next();
            String paramValue = (String)initParamMap.get(paramName);
            config.addInitParameter(paramName,paramValue);
        }
        config.setFilterName(filterTag.getFilterName());
        return config;
    }
    
    /**
     * NGXgtB^[̃XgԂ܂B
     * @param resourcePath
     * @param servletName
     * @return List tB^[̃Xg@tB^[ȂꍇÃXgԂ܂B
     * @throws ServletException
     */
    public List findFilters(String resourcePath,String servletName) throws ServletException
	{
        List filterList = new ArrayList();        
        if(resourcePath != null && filterMap != null)
        {
	        List mappingList = webXml.getWebApp().getFilterMappingList();
	        
	        for(Iterator mappingItr = mappingList.iterator();mappingItr.hasNext();)
	        {
	            FilterMappingTag mapping = (FilterMappingTag)mappingItr.next();
	            List patternList = mapping.getUrlPatternList();
	            patternmatch:
	            for(Iterator patternItr = patternList.iterator();patternItr.hasNext();)
	            {
	                String patternText = (String)patternItr.next();
	                if(PathUtils.matchPattern(patternText,resourcePath))
	                {	
	                    String filterName = mapping.getFilterName();
	                    Filter filter = (Filter)filterMap.get(filterName);
	                    filterList.add(filter);
	                    break patternmatch;
	                }
	            }
	            
	            List servletNameList = mapping.getServletNameList();
	            namematch:
	            for(Iterator patternItr = servletNameList.iterator();patternItr.hasNext();)
	            {
	                String name = (String)patternItr.next();
	                if(name.equals(servletName))
	                {	
	                    String filterName = mapping.getFilterName();
	                    Filter filter = (Filter)filterMap.get(filterName);
	                    filterList.add(filter);
	                    break namematch;
	                }
	            }
	        }
        }
        return filterList;        
	}
    /**
     * NGXgT[ubgԂ܂B
     * @param urlPattern
     * @return servlet T[ubgȂꍇAnullԂ܂B
     * @throws ServletException
     */
    public Servlet findServlet(String resourcePath) throws ServletException
    {
        if(resourcePath != null && servletMap != null)
        {
	        List mappingList = webXml.getWebApp().getServletMappingList();
	        for(Iterator mappingItr = mappingList.iterator();mappingItr.hasNext();)
	        {
	            ServletMappingTag mapping = (ServletMappingTag)mappingItr.next();
	            List patternList = mapping.getUrlPatternList();
	            for(Iterator patternItr = patternList.iterator();patternItr.hasNext();)
	            {
	                String patternText = (String)patternItr.next();
	                if(PathUtils.matchPattern(patternText,resourcePath))
	                {	
	                	String servletName = mapping.getServletName();
	                	Servlet servlet = (Servlet)servletMap.get(servletName);
	                	return servlet;
	                }
	            }
	        }
        }
        return null;
    }	
    public List getServletList()
    {
    	if(servletMap != null)
    		return new ArrayList(servletMap.values());
    	else
    		return null;    		
    }
}
