package net.souko105.flashserver.javaee.imp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

import org.apache.commons.collections.iterators.IteratorEnumeration;

/**
 * HttpSessionNX
 * @author AKatayama
 */
public class HttpSessionImp implements HttpSession
{
    private String id;
    private long creationTime;
    private long lastAccessedTime;
    private ServletContext servletContext;
    private int maxInactiveInterval;
    private Map attributeMap = new HashMap();
    private boolean invalidate = false;
    private boolean isNew = true;
    
    public HttpSessionImp(String sessionId)
    {
        this.id = sessionId;     
        this.creationTime = System.currentTimeMillis();
    }
    public long getCreationTime()
    {
        checkInvalidate();
        return creationTime;
    }
    public String getId()
    {
        checkInvalidate();
        return id;
    }
    public long getLastAccessedTime()
    {
        checkInvalidate();
        return lastAccessedTime;
    }
    public ServletContext getServletContext()
    {
        checkInvalidate();
        return servletContext;
    }
    public void setMaxInactiveInterval(int interval)
    {
        checkInvalidate();
        this.maxInactiveInterval = interval;
    }
    public int getMaxInactiveInterval()
    {
        checkInvalidate();
        return maxInactiveInterval;
    }
    public HttpSessionContext getSessionContext()
    {
       throw new RuntimeException("getSessionConetxt not implemented");
    }
    public Object getAttribute(String key)
    {
        checkInvalidate();
        return attributeMap.get(key);
    }
    public Object getValue(String key)
    {
        checkInvalidate();
        return getAttribute(key);
    }
    public Enumeration getAttributeNames()
    {
        checkInvalidate();
        return new IteratorEnumeration(attributeMap.keySet().iterator());
    }
    public String[] getValueNames()
    {
        checkInvalidate();
        return (String[])attributeMap.keySet().toArray(new String[]{});
    }
    public void setAttribute(String key, Object value)
    {
        checkInvalidate();
        attributeMap.put(key,value);
    }
    public void putValue(String key, Object value)
    {
        checkInvalidate();
        setAttribute(key,value);
    }
    public void removeAttribute(String key)
    {
        checkInvalidate();
        attributeMap.remove(key);
    }
    public void removeValue(String key)
    {
        checkInvalidate();
        removeAttribute(key);
    }
    public void invalidate()
    {
        this.invalidate = true;
    }
    public boolean isNew()
    {
        return isNew;
    }
    
    ///non interface method
    public boolean isInvalidate()
    {
        return invalidate;
    }
    private void checkInvalidate()
    {
        if(invalidate)//gps\
            throw new RuntimeException("Session invalidated.");
    }   
    public void setInvalidate(boolean invalidate)
    {
        this.invalidate = invalidate;
    }
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }
    public void setServletContext(ServletContext servletContext)
    {
        this.servletContext = servletContext;
    }
}
