package net.souko105.flashserver;

import java.io.IOException;
import java.io.InputStream;

/**
 * HttpInputStreamNX
 * @author AKatayama
 */
public class HttpInputStream extends InputStream
{
	private InputStream isImp;
    private boolean skipFirstLF = false;
    private Object lock = new Object();
    
	public HttpInputStream(InputStream is) 
	{
		super();
		this.isImp = is;
	}
    public String readLine() throws IOException
	{
    	return readLine(false);
	}
    public String readLine(boolean ignoreLF) throws IOException
    {
        StringBuffer s = new StringBuffer();
        synchronized (lock)
        {
            for (;;)
            {
            	int readChar = read();
            	//eof?
            	if(readChar < 0)
            		return (s.length()>0)?s.toString():null;
            	
            	char c = (char)readChar;
            	
            	if(ignoreLF && c == '\n')//ignoreLF
            			continue;

            	if(c== '\n' || c == '\r')//eol
            	{
                    if (c == '\r')
                        skipFirstLF = true;
            		return s.toString();
            	}
            	
            	s.append(c);
            }
        }
    }
    public int read() throws IOException
	{
    	int c = isImp.read();
    	//CRŏILFǂݍ܂Ȃ
    	if(skipFirstLF && c == '\n')
    	{
    		skipFirstLF = false;
    		c = isImp.read();
    	}
    	return c;
    }
}
