/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.souko105.flashserver.util.IOUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static URL[] archivePathString2URLs(String paths) throws MalformedURLException {
        StringTokenizer token = new StringTokenizer(paths, ";", false);
        ArrayList<URL> urlList = new ArrayList<URL>();
        while (token.hasMoreTokens()) {
            String path = token.nextToken();
            urlList.add(new URL("file:///" + path));
        }
        return urlList.toArray(new URL[0]);
    }

    public static String createArchiveClassPathString(String targetDir) throws MalformedURLException {
        URL[] urls = PathUtils.createArchiveClassPaths(targetDir);
        if (urls == null) {
            return null;
        }
        StringBuffer path = new StringBuffer();
        int i = 0;
        while (i < urls.length) {
            String libPath = urls[i].toString();
            if (libPath.startsWith("file:/")) {
                libPath = libPath.substring("file:/".length());
            }
            if (i == 0) {
                path.append(libPath);
            } else {
                path.append(";" + libPath);
            }
            ++i;
        }
        return path.toString();
    }

    public static URL[] createArchiveClassPaths(String targetDir) throws MalformedURLException {
        File[] dirs;
        File libDir = new File(targetDir);
        if (!libDir.exists()) {
            return null;
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        File[] libs = libDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip");
            }
        });
        if (libs != null) {
            int i = 0;
            while (i < libs.length) {
                String libPath = libs[i].getAbsolutePath();
                libPath = IOUtils.replaceFileSeparator(libPath);
                urlList.add(new URL("file:///" + libPath));
                ++i;
            }
        }
        if ((dirs = libDir.listFiles()) != null) {
            int i = 0;
            while (i < dirs.length) {
                URL[] urls;
                if (dirs[i].isDirectory() && (urls = PathUtils.createArchiveClassPaths(dirs[i].getAbsolutePath())) != null) {
                    int j = 0;
                    while (j < urls.length) {
                        urlList.add(urls[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return urlList.toArray(new URL[0]);
    }

    public static String getContextPath(String requestURI) {
        if (requestURI == null) {
            return null;
        }
        if (requestURI.startsWith("/")) {
            if (requestURI.indexOf("/", 1) != -1) {
                String contextPath = requestURI.substring(0, requestURI.indexOf("/", 1));
                return contextPath;
            }
            return requestURI;
        }
        return null;
    }

    public static String getResourcePath(String requestURI) {
        if (requestURI == null) {
            return null;
        }
        if (requestURI.startsWith("/") && requestURI.length() > 1 && requestURI.indexOf("/", 1) >= 1) {
            String servletPath = requestURI.substring(requestURI.indexOf("/", 1), requestURI.length());
            return servletPath;
        }
        return null;
    }

    public static boolean matchPattern(String pattern, String resourcePath) {
        int resourceDot;
        if (pattern == null || resourcePath == null) {
            return false;
        }
        if (pattern.equals(resourcePath)) {
            return true;
        }
        if (pattern.equals("/*")) {
            return true;
        }
        if (pattern.endsWith("/*")) {
            if (pattern.regionMatches(0, resourcePath, 0, pattern.length() - 2)) {
                if (resourcePath.length() == pattern.length() - 2) {
                    return true;
                }
                if (resourcePath.charAt(pattern.length() - 2) == '/') {
                    return true;
                }
            }
            return false;
        }
        if (pattern.startsWith("*.") && (resourceDot = resourcePath.lastIndexOf(".")) >= 0) {
            int patternDot;
            String patternExt;
            String resourceExt = resourcePath.substring(resourceDot, resourcePath.length());
            return resourceExt.equals(patternExt = pattern.substring(patternDot = pattern.indexOf("."), pattern.length()));
        }
        return false;
    }
}

