/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.souko105.flashserver.javaee.imp.FilterConfigImp;
import net.souko105.flashserver.javaee.imp.ServletConfigImp;
import net.souko105.flashserver.javaee.imp.ServletContextImp;
import net.souko105.flashserver.javaee.imp.WebAppClassLoader;
import net.souko105.flashserver.javaee.imp.WebAppInitializeException;
import net.souko105.flashserver.javaee.webxml.FilterMappingTag;
import net.souko105.flashserver.javaee.webxml.FilterTag;
import net.souko105.flashserver.javaee.webxml.ServletMappingTag;
import net.souko105.flashserver.javaee.webxml.ServletTag;
import net.souko105.flashserver.javaee.webxml.WebXml;
import net.souko105.flashserver.util.PathUtils;

public class WebApp {
    private WebXml webXml;
    private String absoluteContextPath;
    private String contextPath;
    private WebAppClassLoader webAppClassLoader;
    private ServletContextImp servletContext;
    private Map servletMap;
    private Map filterMap;

    WebApp(WebXml webXml, String absoluteContextPath, String contextPath, WebAppClassLoader webAppClassLoader) throws WebAppInitializeException {
        this.webXml = webXml;
        this.absoluteContextPath = absoluteContextPath;
        this.contextPath = contextPath;
        this.webAppClassLoader = webAppClassLoader;
        this.init();
    }

    public String getAbsoluteContextPath() {
        return this.absoluteContextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public WebAppClassLoader getWebAppClassLoader() {
        return this.webAppClassLoader;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    private void init() throws WebAppInitializeException {
        this.initServletContext();
        this.initServlet();
        this.initFilter();
    }

    private void initServletContext() {
        this.servletContext = new ServletContextImp();
        this.servletContext.setAbsoluteContextPath(this.absoluteContextPath);
        this.servletContext.setServletContextName(this.contextPath);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initServlet() throws WebAppInitializeException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppClassLoader);
        try {
            List servletList = this.webXml.getWebApp().getServletList();
            Iterator servletItr = servletList.iterator();
            while (true) {
                block7: {
                    if (servletItr.hasNext()) break block7;
                    this.servletContext.setServletMap(this.servletMap);
                    break;
                }
                if (this.servletMap == null) {
                    this.servletMap = new HashMap();
                }
                ServletTag servletTag = (ServletTag)servletItr.next();
                Servlet servletInstance = (Servlet)this.createInstance(this.webAppClassLoader, servletTag.getServletClass());
                ServletConfig config = this.createServletConfig(servletTag);
                try {
                    servletInstance.init(config);
                }
                catch (ServletException e) {
                    throw new WebAppInitializeException(e);
                }
                this.servletMap.put(servletTag.getServletName(), servletInstance);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
        {
            Object var8_10 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initFilter() throws WebAppInitializeException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppClassLoader);
        try {
            List filterList = this.webXml.getWebApp().getFilterList();
            Iterator filterItr = filterList.iterator();
            while (filterItr.hasNext()) {
                if (this.filterMap == null) {
                    this.filterMap = new HashMap();
                }
                FilterTag filterTag = (FilterTag)filterItr.next();
                Filter filterInstance = (Filter)this.createInstance(this.webAppClassLoader, filterTag.getFilterClass());
                FilterConfig config = this.createFilterConfig(filterTag);
                try {
                    filterInstance.init(config);
                }
                catch (ServletException e) {
                    throw new WebAppInitializeException(e);
                }
                this.filterMap.put(filterTag.getFilterName(), filterInstance);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable;
        }
        {
            Object var8_10 = null;
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            return;
        }
    }

    private Object createInstance(ClassLoader webAppClassLoader, String className) throws WebAppInitializeException {
        try {
            Class<?> clazz = webAppClassLoader.loadClass(className);
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new WebAppInitializeException("Class not found. className=" + className, e);
        }
        catch (InstantiationException e) {
            throw new WebAppInitializeException("Class instantiate fail. className=" + className, e);
        }
        catch (IllegalAccessException e) {
            throw new WebAppInitializeException("Class access fail. className=" + className, e);
        }
    }

    private ServletConfig createServletConfig(ServletTag servletTag) {
        ServletConfigImp config = new ServletConfigImp();
        config.setServletContext(this.servletContext);
        Map initParamMap = servletTag.getInitParamMap();
        Iterator paramItr = initParamMap.keySet().iterator();
        while (paramItr.hasNext()) {
            String paramName = (String)paramItr.next();
            String paramValue = (String)initParamMap.get(paramName);
            config.addInitParameter(paramName, paramValue);
        }
        config.setServletName(servletTag.getServletName());
        return config;
    }

    private FilterConfig createFilterConfig(FilterTag filterTag) {
        FilterConfigImp config = new FilterConfigImp();
        config.setServletContext(this.servletContext);
        Map initParamMap = filterTag.getInitParamMap();
        Iterator paramItr = initParamMap.keySet().iterator();
        while (paramItr.hasNext()) {
            String paramName = (String)paramItr.next();
            String paramValue = (String)initParamMap.get(paramName);
            config.addInitParameter(paramName, paramValue);
        }
        config.setFilterName(filterTag.getFilterName());
        return config;
    }

    public List findFilters(String resourcePath, String servletName) throws ServletException {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (resourcePath != null && this.filterMap != null) {
            List mappingList = this.webXml.getWebApp().getFilterMappingList();
            Iterator mappingItr = mappingList.iterator();
            block0: while (mappingItr.hasNext()) {
                FilterMappingTag mapping = (FilterMappingTag)mappingItr.next();
                List patternList = mapping.getUrlPatternList();
                Iterator patternItr = patternList.iterator();
                while (patternItr.hasNext()) {
                    String patternText = (String)patternItr.next();
                    if (!PathUtils.matchPattern(patternText, resourcePath)) continue;
                    String filterName = mapping.getFilterName();
                    Filter filter = (Filter)this.filterMap.get(filterName);
                    filterList.add(filter);
                    break;
                }
                List servletNameList = mapping.getServletNameList();
                Iterator patternItr2 = servletNameList.iterator();
                while (patternItr2.hasNext()) {
                    String name = (String)patternItr2.next();
                    if (!name.equals(servletName)) continue;
                    String filterName = mapping.getFilterName();
                    Filter filter = (Filter)this.filterMap.get(filterName);
                    filterList.add(filter);
                    continue block0;
                }
            }
        }
        return filterList;
    }

    public Servlet findServlet(String resourcePath) throws ServletException {
        if (resourcePath != null && this.servletMap != null) {
            List mappingList = this.webXml.getWebApp().getServletMappingList();
            Iterator mappingItr = mappingList.iterator();
            while (mappingItr.hasNext()) {
                ServletMappingTag mapping = (ServletMappingTag)mappingItr.next();
                List patternList = mapping.getUrlPatternList();
                Iterator patternItr = patternList.iterator();
                while (patternItr.hasNext()) {
                    String patternText = (String)patternItr.next();
                    if (!PathUtils.matchPattern(patternText, resourcePath)) continue;
                    String servletName = mapping.getServletName();
                    Servlet servlet = (Servlet)this.servletMap.get(servletName);
                    return servlet;
                }
            }
        }
        return null;
    }

    public List getServletList() {
        if (this.servletMap != null) {
            return new ArrayList(this.servletMap.values());
        }
        return null;
    }
}

