/*
 * Decompiled with CFR 0.152.
 */
package net.souko105.flashserver.javaee.imp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.souko105.flashserver.HttpHeaderConst;
import net.souko105.flashserver.HttpResponseHeader;
import net.souko105.flashserver.javaee.imp.ServletOutputStreamImp;
import net.souko105.flashserver.util.IOUtils;

public class HttpServletResponseImp
implements HttpServletResponse {
    private Locale locale = Locale.getDefault();
    private HttpResponseHeader header = new HttpResponseHeader();
    private ServletOutputStreamImp servletOutputStream = new ServletOutputStreamImp();
    private PrintWriter writer;
    private int bufferSize;

    public void addCookie(Cookie cookie) {
        this.header.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.header.containsHeader(name);
    }

    public String getContentType() {
        return this.header.getHeader("Content-Type");
    }

    public void setContentLength(int length) {
        this.header.addHeader("Content-Length", String.valueOf(length));
    }

    public void setContentType(String type) {
        this.header.addHeader("Content-Type", type);
    }

    public void setStatus(int sc) {
        this.header.setStatusCode(sc);
        this.header.setStatus(HttpHeaderConst.findStatus(sc));
    }

    public void setStatus(int sc, String msg) {
        this.header.setStatus(msg);
        this.header.setStatusCode(sc);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String uri) {
        return uri;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public void sendError(int arg0, String arg1) throws IOException {
    }

    public void sendError(int arg0) throws IOException {
    }

    public void sendRedirect(String arg0) throws IOException {
    }

    public void setDateHeader(String name, long time) {
        this.header.addHeader(name, IOUtils.HEADER_DATE_FORMAT.format(new Date(time)));
    }

    public void addDateHeader(String name, long time) {
        this.header.addHeader(name, IOUtils.HEADER_DATE_FORMAT.format(new Date(time)));
    }

    public void setHeader(String name, String value) {
        this.header.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.header.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.header.addHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.header.addHeader(name, String.valueOf(value));
    }

    public String getCharacterEncoding() {
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((OutputStream)((Object)this.servletOutputStream));
        }
        return this.writer;
    }

    public void setCharacterEncoding(String arg0) {
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.servletOutputStream.flush();
    }

    public void resetBuffer() {
        this.servletOutputStream = new ServletOutputStreamImp();
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
        this.servletOutputStream = new ServletOutputStreamImp();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public byte[] getBodyData() throws IOException {
        this.flushBuffer();
        this.servletOutputStream.close();
        return this.servletOutputStream.getOutputData();
    }

    public HttpResponseHeader getResponseHeader() {
        return this.header;
    }
}

