<?php
require_once ('cssj/cssj_driver.php');
require_once ('smarty/Smarty.class.php');

global $G_tpl_params;
$G_tpl_params = array();

function tpl_smarty_create()
{
	$basedir = dirname(__FILE__).'/../';
 	$smarty = new Smarty();
	$smarty->template_dir = "$basedir/data";
	$smarty->compile_dir = "$basedir/work/templates_c/";
	$smarty->config_dir = "$basedir/data/configs";
	$smarty->cache_dir = "$basedir/work/cache/";
	$smarty->plugins_dir = array('plugins/', "$basedir/inc/plugins/");
	return $smarty;
}

function tpl_create_session()
{
	$driver = cssj_create_driver_for('localhost', 8099);
	$session = cssj_create_session($driver, 'user', 'kappa')
	    or die('Copper PDF サーバーに接続できません');
	return $session;
}

function tpl_show_form($view, $tplname, $tpl = NULL)
{
	global $G_tpl_params;
	$G_tpl_params['view'] = $view;
	$G_tpl_params['spec'] = array();
	$G_tpl_params['comment'] = array();
	$G_tpl_params['constraints'] = array();
	$G_tpl_params['errors'] = array();
	$G_tpl_params['invalids'] = array();
	
	$smarty = tpl_smarty_create();
	$smarty->assign('tplname', $tplname);
	$smarty->assign('rsrcs', "rsrc.php/$tplname");
	$smarty->assign_by_ref('G_tpl_params', $G_tpl_params);
	$smarty->assign('year',date('Y'));
	$smarty->assign('month',date('n'));
	$smarty->assign('day',date('j'));

	$dir = dirname(__FILE__);
	$dir = "$dir/../data/templates";
		
	if ($tpl != NULL) {
		$smarty->assign('edit', TRUE);
	}
	else {
		$tpl = file_get_contents("$dir/$tplname/form.tpl.html");
	}
	$smarty->assign('tpl', $tpl);
	
	switch($view) {
	case 'web':
		// ウェブフォーム
		header('Content-Type: text/html');
		$smarty->display("inc/view/$view.tpl.html");
		break;
	
	default:
		// 記入用紙
		if ($view === 'print') {
			ob_start();
			$smarty->display("templates/$tplname/constraints.tpl.html");
			ob_end_clean();
			if(!empty($G_tpl_params['errors'])) {
				$G_tpl_params['view'] = $view = 'web';
				header('Content-Type: text/html');
				$smarty->display("inc/view/$view.tpl.html");
				exit;
			}
		}
		
		header('Content-Type: application/pdf');
		
		$session = tpl_create_session();
		    
		// リソース送信
		$dir = "$dir/$tplname/rsrcs";
	    if ($dh = opendir($dir)) {
	        while (($file = readdir($dh)) !== false) {
	        	$filepath = "$dir/$file";
	        	if (is_dir($filepath))
	        	{
	        		continue;
	        	}
				cssj_ob_start_resource($session, "file:/rsrc.php/$tplname/$file");
				readfile($filepath, TRUE);
				cssj_ob_end_flush_resource();
	        }
	        closedir($dh);
	    }
		    
		// 本体送信
		cssj_ob_start_main($session, 'file:/form.html', 'text/html', 'UTF-8');
		$smarty->display("inc/view/$view.tpl.html");
		cssj_ob_end_flush_main();
		
		cssj_close($session);
		break;
	}
}

?>