<?php
function smarty_function_text($params, &$smarty) {
	global $G_tpl_params;
	$view = $G_tpl_params['view'];
	
	$name = $params['name'];
	$size = $params['size'];
	
	switch($view) {
		case 'spec':
		$params['type'] = 'text';
		$G_tpl_params['spec'][] = $params;
		return;
		
		case 'blank':
		return '<span style="display: inline-block; width: '.$size.'em;"></span>';
		
		case 'print':
		$value = $_POST[$name];
		return '<span class="input" style="display: inline-block; width: '.$size.'em;">'.htmlspecialchars($value).'</span>';
		
		case 'web':
		if ($_POST['view'] === 'print') {
			$value = $_POST[$name];
		}
		else {
			$value = $params['default'];
		}
		$item = '<input type="text"
			name="'.htmlspecialchars($name).'"
			size="'.$size.'" style="width: '.$size.'em;"
			value="'.htmlspecialchars($value).'">';
		
		$invalids = $G_tpl_params['invalids'];
		if (isset($invalids[$name])) {
			$item = '<span class="invalid">'.$item.'</span>';
		}
		return $item;
	}
}
?>