<?php
function smarty_function_longtext($params, &$smarty) {
	global $G_tpl_params;
	$view = $G_tpl_params['view'];
	
	$name = $params['name'];
	$rows = $params['rows'];
	$cols = $params['cols'];
	
	switch($view) {
		case 'spec':
		$params['type'] = 'longtext';
		$G_tpl_params['spec'][] = $params;
		return;
		
		case 'blank':
		return '<span style="display: inline-block; width: '.$cols.'em; height: '.$rows.'em;"></span>';
		
		case 'print':
		$value = $_POST[$name];
		return '<span class="input" style="display: inline-block; width: '.$cols.'em; height: '.$rows.'em;">'.htmlspecialchars($value).'</span>';
		
		case 'web':
		if ($_POST['view'] === 'print') {
			$value = $_POST[$name];
		}
		else {
			$value = $params['default'];
		}
		$item = '<textarea
			name="'.htmlspecialchars($name).'"
			cols="'.$cols.'" rows="'.$rows.'"
			style="width: '.$cols.'em; height: '.$rows.'em;">'.htmlspecialchars($value).'</textarea>';
		
		$invalids = $G_tpl_params['invalids'];
		if (isset($invalids[$name])) {
			$item = '<span class="invalid">'.$item.'</span>';
		}
		return $item;
	}
}
?>