/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.tools.imposer;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.cssj.tools.imposer.Imposition;
import jp.cssj.tools.imposer.PdfUtils;

public class DoubleSideSaddle4Imposition
implements Imposition {
    private float cuttingMargin = PdfUtils.mmToPoint(3.0f);
    private String title = "";
    private float paperWidth = PdfUtils.mmToPoint(310.0f);
    private float paperHeight = PdfUtils.mmToPoint(438.0f);

    public float getCuttingMargin() {
        return PdfUtils.pointToMm(this.cuttingMargin);
    }

    public void setCuttingMargin(float cuttingMargin) {
        this.cuttingMargin = PdfUtils.mmToPoint(cuttingMargin);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public float getPaperWidth() {
        return PdfUtils.pointToMm(this.paperWidth);
    }

    public void setPaperWidth(float paperWidth) {
        this.paperWidth = PdfUtils.mmToPoint(paperWidth);
    }

    public float getPaperHeight() {
        return PdfUtils.pointToMm(this.paperHeight);
    }

    public void setPaperHeight(float paperHeight) {
        this.paperHeight = PdfUtils.mmToPoint(paperHeight);
    }

    public void impose(String srcFile, String destFile) throws IOException, DocumentException {
        PdfReader sourcePdf = new PdfReader(srcFile);
        Rectangle size = sourcePdf.getPageSize(1);
        float pageWidth = size.getWidth();
        float pageHeight = size.getHeight();
        int srcPageCount = sourcePdf.getNumberOfPages();
        int destPageCount = (int)Math.ceil((float)srcPageCount / 8.0f) * 2;
        float vtrim = (this.paperHeight - pageHeight * 2.0f) / 4.0f;
        float htrim = (this.paperWidth - pageWidth * 2.0f) / 2.0f;
        Document destDoc = new Document(new Rectangle((int)this.paperWidth, (int)this.paperHeight));
        PdfWriter destPdf = PdfWriter.getInstance(destDoc, new FileOutputStream(destFile));
        destDoc.open();
        for (int i = 0; i < destPageCount; ++i) {
            Rectangle bounds;
            PdfImportedPage page;
            destDoc.newPage();
            PdfContentByte cb = destPdf.getDirectContent();
            int a = 0;
            int b = 0;
            int c = 0;
            int d = 0;
            String aTitle = "";
            String bTitle = "";
            String cTitle = "";
            String dTitle = "";
            if (i % 2 == 0) {
                a = destPageCount * 4 - i;
                b = i + 1;
                c = destPageCount * 2 + i + 1;
                d = destPageCount * 2 - i;
            } else {
                a = i + 1;
                b = destPageCount * 4 - i;
                c = destPageCount * 2 - i;
                d = destPageCount * 2 + i + 1;
            }
            if (a > 0 && a <= srcPageCount) {
                page = destPdf.getImportedPage(sourcePdf, a);
                bounds = page.getBoundingBox();
                bounds.setTop(bounds.getTop() + this.cuttingMargin);
                bounds.setBottom(bounds.getBottom() - this.cuttingMargin);
                bounds.setLeft(bounds.getLeft() - this.cuttingMargin);
                cb.addTemplate(page, -1.0f, 0.0f, 0.0f, -1.0f, pageWidth * 2.0f + htrim, pageHeight * 2.0f + vtrim * 3.0f);
                aTitle = "page " + a + "/" + this.title;
            }
            if (b > 0 && b <= srcPageCount) {
                page = destPdf.getImportedPage(sourcePdf, b);
                bounds = page.getBoundingBox();
                bounds.setTop(bounds.getTop() + this.cuttingMargin);
                bounds.setBottom(bounds.getBottom() - this.cuttingMargin);
                bounds.setRight(bounds.getRight() + this.cuttingMargin);
                cb.addTemplate(page, -1.0f, 0.0f, 0.0f, -1.0f, pageWidth + htrim, pageHeight * 2.0f + vtrim * 3.0f);
                bTitle = "page " + b + "/" + this.title;
            }
            if (c > 0 && c <= srcPageCount) {
                page = destPdf.getImportedPage(sourcePdf, c);
                bounds = page.getBoundingBox();
                bounds.setTop(bounds.getTop() + this.cuttingMargin);
                bounds.setBottom(bounds.getBottom() - this.cuttingMargin);
                bounds.setRight(bounds.getRight() + this.cuttingMargin);
                cb.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, pageWidth + htrim, vtrim);
                cTitle = "page " + c + "/" + this.title;
            }
            if (d > 0 && d <= srcPageCount) {
                page = destPdf.getImportedPage(sourcePdf, d);
                bounds = page.getBoundingBox();
                bounds.setTop(bounds.getTop() + this.cuttingMargin);
                bounds.setBottom(bounds.getBottom() - this.cuttingMargin);
                bounds.setLeft(bounds.getLeft() - this.cuttingMargin);
                cb.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, htrim, vtrim);
                dTitle = "page " + d + "/" + this.title;
            }
            cb.setLineWidth(0.5f);
            this.drawMarks(cb, pageWidth, pageHeight, htrim, vtrim, 0.0f, this.paperHeight / 2.0f, aTitle, bTitle);
            this.drawMarks(cb, pageWidth, pageHeight, htrim, vtrim, 0.0f, 0.0f, cTitle, dTitle);
        }
        destDoc.close();
    }

    private void drawMarks(PdfContentByte cb, float pageWidth, float pageHeight, float htrim, float vtrim, float xx, float yy, String leftTitle, String rightTitle) throws IOException, DocumentException {
        BaseFont bf = BaseFont.createFont("HeiseiKakuGo-W5", "UniJIS-UCS2-HW-H", false);
        float x = xx + htrim + pageWidth;
        float y = yy;
        cb.moveTo(x, y);
        cb.lineTo(x, y + vtrim - this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x - htrim, y + vtrim / 2.0f);
        cb.lineTo(x + htrim, y + vtrim / 2.0f);
        cb.stroke();
        y = yy + pageHeight + vtrim * 2.0f;
        cb.moveTo(x, y);
        cb.lineTo(x, y - vtrim + this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x - htrim, y - vtrim / 2.0f);
        cb.lineTo(x + htrim, y - vtrim / 2.0f);
        cb.stroke();
        x = xx;
        y = yy + vtrim + pageHeight / 2.0f;
        cb.moveTo(x, y);
        cb.lineTo(x + htrim - this.cuttingMargin, y);
        cb.stroke();
        cb.moveTo(x + htrim / 2.0f, y - vtrim);
        cb.lineTo(x + htrim / 2.0f, y + vtrim);
        cb.stroke();
        x = xx + htrim * 2.0f + pageWidth * 2.0f;
        cb.moveTo(x, y);
        cb.lineTo(x - htrim + this.cuttingMargin, y);
        cb.stroke();
        cb.moveTo(x - htrim / 2.0f, y - vtrim);
        cb.lineTo(x - htrim / 2.0f, y + vtrim);
        cb.stroke();
        x = xx;
        y = yy + vtrim * 2.0f + pageHeight;
        cb.moveTo(x, y - vtrim);
        cb.lineTo(x + htrim - this.cuttingMargin, y - vtrim);
        cb.stroke();
        cb.moveTo(x, y - vtrim + this.cuttingMargin);
        cb.lineTo(x + htrim - this.cuttingMargin, y - vtrim + this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x + htrim - this.cuttingMargin, y);
        cb.lineTo(x + htrim - this.cuttingMargin, y - vtrim + this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x + htrim, y);
        cb.lineTo(x + htrim, y - vtrim + this.cuttingMargin);
        cb.stroke();
        float fontSize = 6.0f;
        cb.beginText();
        cb.setFontAndSize(bf, fontSize);
        cb.showTextAligned(0, leftTitle, x + htrim + fontSize, y - fontSize, 0.0f);
        cb.showTextAligned(0, rightTitle, x + htrim + pageWidth + fontSize, y - fontSize, 0.0f);
        cb.endText();
        y = yy;
        cb.moveTo(x, y + vtrim);
        cb.lineTo(x + htrim - this.cuttingMargin, y + vtrim);
        cb.stroke();
        cb.moveTo(x, y + vtrim - this.cuttingMargin);
        cb.lineTo(x + htrim - this.cuttingMargin, y + vtrim - this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x + htrim - this.cuttingMargin, y);
        cb.lineTo(x + htrim - this.cuttingMargin, y + vtrim - this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x + htrim, y);
        cb.lineTo(x + htrim, y + vtrim - this.cuttingMargin);
        cb.stroke();
        x = xx + htrim * 2.0f + pageWidth * 2.0f;
        y = yy + vtrim * 2.0f + pageHeight;
        cb.moveTo(x, y - vtrim);
        cb.lineTo(x - htrim + this.cuttingMargin, y - vtrim);
        cb.stroke();
        cb.moveTo(x, y - vtrim + this.cuttingMargin);
        cb.lineTo(x - htrim + this.cuttingMargin, y - vtrim + this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x - htrim + this.cuttingMargin, y);
        cb.lineTo(x - htrim + this.cuttingMargin, y - vtrim + this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x - htrim, y);
        cb.lineTo(x - htrim, y - vtrim + this.cuttingMargin);
        cb.stroke();
        y = yy;
        cb.moveTo(x, y + vtrim);
        cb.lineTo(x - htrim + this.cuttingMargin, y + vtrim);
        cb.stroke();
        cb.moveTo(x, y + vtrim - this.cuttingMargin);
        cb.lineTo(x - htrim + this.cuttingMargin, y + vtrim - this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x - htrim + this.cuttingMargin, y);
        cb.lineTo(x - htrim + this.cuttingMargin, y + vtrim - this.cuttingMargin);
        cb.stroke();
        cb.moveTo(x - htrim, y);
        cb.lineTo(x - htrim, y + vtrim - this.cuttingMargin);
        cb.stroke();
    }
}

