package org.dyndns.nuda.mapper;

import java.io.Serializable;

/**
 * SQLXMLを表すJavaBeansです
 * 
 * @author nkoseki
 * 
 */
public class QueryXMLBean implements Serializable {
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 1L;
	private String				id					= "";
	private String				type				= "";
	private String				sql					= "";
	
	public String getId() {
		return this.id;
	}
	
	public void setId(final String id) {
		this.id = id;
	}
	
	public String getType() {
		return this.type;
	}
	
	public void setType(final String type) {
		this.type = type;
	}
	
	public String getSql() {
		return this.sql;
	}
	
	public void setSql(final String sql) {
		this.sql = sql;
	}
	
	@Override
	public String toString() {
		return "QueryXMLBean [id=" + this.id + ", type=" + this.type + ", sql="
				+ this.sql + "]";
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((this.id == null) ? 0 : this.id.hashCode());
		result = prime * result
				+ ((this.sql == null) ? 0 : this.sql.hashCode());
		result = prime * result
				+ ((this.type == null) ? 0 : this.type.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		QueryXMLBean other = (QueryXMLBean) obj;
		if (this.id == null) {
			if (other.id != null) {
				return false;
			}
		} else if (!this.id.equals(other.id)) {
			return false;
		}
		if (this.sql == null) {
			if (other.sql != null) {
				return false;
			}
		} else if (!this.sql.equals(other.sql)) {
			return false;
		}
		if (this.type == null) {
			if (other.type != null) {
				return false;
			}
		} else if (!this.type.equals(other.type)) {
			return false;
		}
		return true;
	}
	
}
