
program = {
  comment:  "file copy with CRLF -> LF in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2003/01/30 11:52:52 $";
  revision: "$Revision: 1.1 $";

  fun usage(){
    do: println "usage: soopy crlf.sp src_file dist_file dist2";
  };

  fun with_openIn_file(filename, body){
    comment: "open input-file & eval body & close file";
    var: [fin];
    do: [
      fin = openIn filename;
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openOut_file(filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout];
    do: [
      fout = openOut filename;
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun with_openEncodeIn_file(encoder, filename, body){
    comment: "open file & eval body & close file";
    var: [fin, f];
    do: [
      #f = Raw openIn filename;
      f = openIn filename;
      fin = encoder encoderIn(f);
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openEncodeOut_file(encoder, filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout, f];
    do: [
      #f = Raw openOut filename;
      f = openOut filename;
      fout = encoder encoderOut(f);
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun copy(src, dist){
    comment: "copy file from src to dist";
    do: with_openIn_file src {
          arg: [fin];
          var: [ch];
          do: [
                with_openEncodeOut_file LF2CR dist {
                  arg: [fout];
                  do: [
                    loop {
                      from: ch = fin readChar;
                      step: ch = fin readChar;
                      until: fin eof?;
                      do: fout writeChar ch;
                    };
                  ];
                };
              ];
        };
  };

  fun copy2(src, dist){
    comment: "copy file from src to dist";
    do: with_openEncodeIn_file LF2CR src {
          arg: [fin];
          var: [ch];
          do: [
                with_openOut_file dist {
                  arg: [fout];
                  do: [
                    loop {
                      from: ch = fin readChar;
                      step: ch = fin readChar;
                      until: fin eof?;
                      do: fout writeChar ch;
                    };
                  ];
                };
              ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      if(files){
        [x,y,z]: [copy(x,y); copy2(x,z);];
        _:     usage();
      };
    ];
  };
};

program main();

