
program = {
  comment:  "file copy in soopy2";
  author:   "$Author: randy $";
  date:     "$Date: 2003/01/29 11:08:03 $";
  revision: "$Revision: 1.2 $";

  fun usage(){
    do: [
      println "usage: soopy cp3.sp input_encode_type src_file output_encode_type dist_file";
      println "  ex. soopy cp3.sp sjis sjis.txt eucjp output.txt";
    ];
  };

  fun with_openEncodeIn_file(encoder, filename, body){
    comment: "open file & eval body & close file";
    var: [fin, f];
    do: [
      f = Raw openIn filename;
      fin = encoder encoderIn(f);
      body eval(fin);
      fin close;
    ];
    rescue: fin close;
  };

  fun with_openEncodeOut_file(encoder, filename, body){
    comment: "open output-file & eval body & close file";
    var: [fout, f];
    do: [
      f = Raw openOut filename;
      fout = encoder encoderOut(f);
      body eval(fout);
      fout close;
    ];
    rescue: fout close;
  };

  fun copy(src_encode, src, dist_encode, dist){
    comment: "copy file from src to dist";
    do: with_openEncodeIn_file src_encode src {
          arg: [fin];
          var: [line];
          do: [
                with_openEncodeOut_file dist_encode dist {
                  arg: [fout];
                  do: [
                    loop {
                      from: line = fin readLine;
                      step: line = fin readLine;
                      until: fin eof?;
                      do: fout writeLine line;
                    };
                  ];
                };
              ];
        };
  };

  /*
   * Main routine
   */
  fun main(){
    comment: "main routine";
    var: [files];
    do: [
      files = Soopy commandLine;
      if(files){
        [enc1,x,enc2,y]: copy((enc1 symbol), x, (enc2 symbol), y);
        _:               usage();
      };
    ];
  };
};

program main();

