class TicketLogs < ActiveRecord::Base
  belongs_to :project
  belongs_to :state, class_name: 'State', foreign_key: 'state_id'
  belongs_to :priority, class_name: 'Priority', foreign_key: 'priority_id'
  belongs_to :workload, class_name: 'Workload', foreign_key: 'workload_id'
  belongs_to :assigned_user, class_name: 'User', foreign_key: 'assigned_user_id'
  belongs_to :created_by, class_name: 'User', foreign_key: 'updated_by_user_id'

  def has_comment?
    not self.comment.nil? and not self.comment.empty?
  end
end
