# -*- coding: utf-8 -*-
class ProjectsUsersController < ApplicationController
  before_filter :admin_authorize

  def create
    # メンバーを追加する
    project_id = params[:project_id]
    ProjectsUsers.create(user_id: params[:projects_users][:user_id],
                         project_id: project_id)

    # 編集中のプロジェクトページを表示する
    redirect_to edit_project_url(id: project_id)
  end

  def destroy
    # メンバーの登録を削除する
    project_id = params[:project_id]
    member = ProjectsUsers.where(user_id: params[:user_id],
                                 project_id: project_id)
    member.destroy_all

    # 編集中のプロジェクトページを表示する
    redirect_to edit_project_url(id: project_id)
  end
end
