# -*- coding: utf-8 -*-
class ProjectsController < ApplicationController
  def index
    user_id = session[:user_id]
    @user = User.find(user_id)

    # プロジェクト一覧を取得する
    @projects = Project.belongs_projects(@user)

    @is_private_project_only =
      @user.projects.where(is_active: true, is_group: true).count.zero?

    # 表示順のためのデータを作成する
    @order_projects = Project.create_order_projects(@projects)
    @changed_id = []
  end

  def new
    @project = Project.new(is_group: false, is_open: false)

    respond_to do |format|
      format.html
      format.js
      format.json { render json: @project, status: :showed, location: @project }
    end
  end

  def create
    @project = Project.new(params[:project])
    @project[:created_by_user_id] = @user.id

    respond_to do |format|
      if @project.save
        format.html { redirect_to projects_url }
        format.js
        format.json { render json: @project,
          status: :created, location: @project }
      else
        format.html { render action: "new" }
        format.json { render json: @project.errors,
          status: :unprocessable_entity }
      end
    end
  end

  def edit
    begin
      @project = Project.find(params[:id])
      @users = Project.classify_users(@project)
    rescue ActiveRecord::RecordNotFound
      logger.error "Attempt to access invalid project #{params[:id]}"
      redirect_to projects_url, notice: 'Invalid project'
    else
      respond_to do |format|
        format.html
        format.js
        format.json { render json: @project,
          status: :showed, location: @project }
      end
    end
  end

  def update
    @project = Project.find(params[:id])
    previous_is_group = @project.is_group

    respond_to do |format|
      if @project.update_attributes(params[:project])
        if @project.is_group != previous_is_group and @project.is_group == true
          format.html { redirect_to edit_project_url(@project) }
          format.json { head :ok }
        else
          format.html { redirect_to projects_url }
          format.json { head :ok }
        end
      else
        format.html { render action: "edit" }
        format.json { render json: @project.errors,
          status: :unprocessable_entity }
      end
    end
  end

  def destroy
    project = Project.find(params[:id])
    project[:is_active] = false

    respond_to do |format|
      project.save()

      format.html { redirect_to projects_url }
      format.json { head :ok }
    end
  end
end
