<?php
class WebSession {
  function start() {
    global $manager;
    if (isset($_COOKIE['USER_NAME'])) {
      $user = $_COOKIE['USER_NAME'];
      $hash = $_COOKIE['HASH_CODE'];
      $account = $manager->find($user) or WebSession::invalid();
      if ($hash != WebSession::hashCode($account)) {
		WebSession::invalid();
      }
    }
  }

  function invalid() {
    WebSession::logout();
    redirect_to("index.php", "Cookie data invalid. Force logout.", 0);
    exit;
  }

  function login($account, $password) {
    if ($account->authenticate($password)) {
      $name = $account->name;
      $password = $account->password;
      setcookie('USER_NAME', $name, time()+30*24*3600);
      setcookie('HASH_CODE', WebSession::hashCode($account), time()+30*24*3600);
      return true;
    }
    else {
      return false;
    }
  }

  function hashCode($account) {
	$name = $account->name;
	$password = $account->password;
	return md5($name.$password);
  }

  function logout() {
    setcookie('USER_NAME', '', time()-3600);
    setcookie('HASH_CODE', '', time()-3600);
  }

  function isLogined() {
    global $manager;
    if (!isset($_COOKIE['USER_NAME'])) {
      return false;
    }
    if (!isset($_COOKIE['HASH_CODE'])) {
      return false;
    }
    $user = $_COOKIE['USER_NAME'];
    $hash = $_COOKIE['HASH_CODE'];
    $account = $manager->find($user);
    return $hash == WebSession::hashCode($account);
  }

  function loginUser() {
    global $manager;
    return $manager->find(WebSession::loginUserName());
  }

  function loginUserName() {
    if (WebSession::isLogined()) {
      $name = $_COOKIE['USER_NAME'];
      return $name ? $name : 'Guest';
    }
    else {
      return 'Guest';
    }
  }

  function isEditable($pageName) {
    if (!WebSession::isLogined()) return false;
    if (WebSession::isOtherUser($pageName)) return false;
    return true;
  }

  function isOtherUser($pageName) {
    return
      WebSession::isUserName($pageName) &&
      $pageName != WebSession::loginUserName();
  }

  function isUserName($pageName) {
    global $manager;
    return in_array($pageName, $manager->accounts());
  }
}


?>
