<?php

class Rss {
  function writeRecentChanges() {
    $itemRetriever = array("WikiPageStorage", "recentChanges");
    $contentsGetter = array("Rss", "makeDiffString");
    list($rdf_li, $items) =
      Rss::makeRssItems($itemRetriever, $contentsGetter, DEFAULT_RECENT_LIST_NUMBER);

    $rss = Rss::makeRssBodyString("Recent Changes", RECENT_CHANGES_RSS_URL, $rdf_li, $items);
    fwrite_safe(RECENT_CHANGES_RSS_PATH, $rss);
  }

  function writeRecentComments() {
    $itemRetriever = array("WikiCommentStorage", "recentComments");
    $contentsGetter = "get_comment_firstlines";
    list($rdf_li, $items) =
      Rss::makeRssItems($itemRetriever, $contentsGetter, DEFAULT_RECENT_LIST_NUMBER);

    $rss = Rss::makeRssBodyString("Recent Comments", RECENT_COMMENTS_RSS_URL, $rdf_li, $items);
    fwrite_safe(RECENT_COMMENTS_RSS_PATH, $rss);
  }

  function makeRssItems($itemRetriever, $contentsGetter, $maximumNumber) {
    $rdf_li = array();
    $items = array();
    foreach (call_user_func($itemRetriever, $maximumNumber) as $item) {
      list($time, $wikiname, $user) = $item;
      $contents = call_user_func($contentsGetter, $wikiname);
      $rssItem = new RssItem($wikiname, $time, $contents, $user);
      $rdf_li[] = $rssItem->rdf_li;
      $items[] = $rssItem->getItemElementString();
    }
    $rdf_li = join("", $rdf_li);
    $items = join("", $items);
    return array($rdf_li, $items);
  }

  function makeDiffString($wikiname) {
    $property = Property::instanceReadOnly();
    $diff_array = $property->get($wikiname, 'diff');
    assert(is_array($diff_array));
    if (count($diff_array) > 0) {
      return htmlspecialchars(join("\n", $diff_array));
    }
    else {
      return "-- no changes or delete only --";
    }
  }

  function makeRssBodyString($title, $url, $rdf_li, $items) {
    $url_base = URL_BASE;
    $site_name = SITE_NAME;
    $rdf_about = htmlspecialchars($url);
    $result = <<<EOD
<?xml version="1.0" encoding="euc-jp"?>
<rdf:RDF 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns="http://purl.org/rss/1.0/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
  xml:lang="ja">
 <channel rdf:about="$rdf_about">
  <title>$site_name $title</title>
  <link>$url_base</link>
  <description>$site_name $title</description>
  <items>
   <rdf:Seq>
   $rdf_li
   </rdf:Seq>
  </items>
 </channel>
$items
</rdf:RDF>
EOD;
    return $result;
  }
}


function get_comment_firstlines($page, $num = RSS_COMMENT_LINE_NUMBER) {
  $comments = WikiCommentStorage::getComments($page);
  $last_comment = $comments[count($comments) - 1];
  $last_comment->unescape();
  $last_content = htmlspecialchars($last_comment->content);
  $lines = explode("\n", rtrim($last_content));
  $first_lines = array_slice($lines, 0, $num);
  return join("\n", $first_lines);
}

class RssItem {
  var $wikiname;
  var $time;
  var $contents;
  var $user;
  var $link;
  var $dc_date;
  var $description;
  var $rdf_li;

  function RssItem($wikiname, $time, $contents, $user) {
    $this->wikiname = $wikiname;
    $this->time = $time;
    $this->contents = $contents;
    $this->user = $user;
    $this->setOtherProperties();
  }

  function setOtherProperties() {
    $this->link = $this->makeLinkString($this->wikiname);
    $this->dc_date = $this->makeDcDateString($this->time);
    $this->description = $this->makeDescription();
    $this->rdf_li = $this->makeRdfLiString();
  }

  function getItemElementString() {
    $result = <<<EOD
<item rdf:about="$this->link">
 <title>$this->wikiname</title>
 <link>$this->link</link>
 <dc:date>$this->dc_date</dc:date>
 <description>$this->description</description>
</item>
EOD;
    return $result;
  }

  function makeLinkString($wikiname){
    $encodedWikiname = htmlspecialchars(urlencode($this->wikiname));
    return URL_BASE."index.php?mod=WikiView&amp;name=".$encodedWikiname;
  }

  function makeDcDateString($time) {
    return preg_replace("/ /", "T", $time)."+9:00";
  }

  function makeDescription() {
    return sprintf("%s (by %s)", $this->contents, $this->user);
  }

  function makeRdfLiString() {
    return sprintf('<rdf:li rdf:resource="%s" />%s', $this->link, "\n");
  }
}

?>
