<?php

class Rss {
  function writeRecentChanges() {
    $property = Property::instance();
    $url_base = URL_BASE;
    $items = array();
    $rdf_li = array();
    foreach (WikiPageStorage::recentChanges(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($time, $wikiname, $user) = $item;
      $dc_date = preg_replace("/ /", "T", $time)."+9:00";
      $link = $url_base."index.php?mod=WikiView&amp;name=".htmlspecialchars(urlencode($wikiname));
      $rdf_li[] = "<rdf:li rdf:resource=\"$link\" />\n";
      $diff_array = $property->get($wikiname, 'diff');
      if (!is_array($diff_array)) $diff_array = array();
      $diff = htmlspecialchars(join("\n", $diff_array));
      $items[] = <<<EOD
<item rdf:about="$link">
 <title>$wikiname</title>
 <link>$link</link>
 <dc:date>$dc_date</dc:date>
 <description>$diff  (by $user)</description>
</item>

EOD;
    }
    $items = join("", $items);
    $rdf_li = join("", $rdf_li);
    $fp = @fopen(RECENT_CHANGES_RSS_PATH, "w");
    if (!$fp) return;
    $out = <<<EOD
<?xml version="1.0" encoding="euc-jp"?>

<rdf:RDF 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns="http://purl.org/rss/1.0/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
  xml:lang="ja">

 <channel rdf:about="http://cake.dyndns.org/sociewiki/">
  <title>SocieWiki Recent Changes</title>
  <link>$url_base</link>
  <description>SocieWiki RecentChanges</description>
  <items>

   <rdf:Seq>
   $rdf_li
   </rdf:Seq>

  </items>
 </channel>

$items

</rdf:RDF>

EOD;
    fwrite($fp, $out);
    fflush($fp);
    fclose($fp);
  }

  # CommentRSS
  function writeRecentComments() {
    $url_base = URL_BASE;
    $items = array();
    $rdf_li = array();
    foreach (WikiCommentStorage::recentComments(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($time, $wikiname, $user) = $item;
      $dc_date = preg_replace("/ /", "T", $time)."+9:00";
      $link = $url_base."index.php?mod=WikiView&amp;name=".htmlspecialchars(urlencode($wikiname))."#comment";
      $rdf_li[] = "<rdf:li rdf:resource=\"$link\" />\n";
      $first_lines = get_comment_firstlines($wikiname);
      $items[] = <<<EOD
<item rdf:about="$link">
 <title>$wikiname</title>
 <link>$link</link>
 <dc:date>$dc_date</dc:date>
 <description>$first_lines  (by $user)</description>
</item>

EOD;
    }
    $items = join("", $items);
    $rdf_li = join("", $rdf_li);
    $fp = @fopen(RECENT_COMMENTS_RSS_PATH, "w");
    if (!$fp) return;
    $out = <<<EOD
<?xml version="1.0" encoding="euc-jp"?>

<rdf:RDF 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns="http://purl.org/rss/1.0/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
  xml:lang="ja">

 <channel rdf:about="http://cake.dyndns.org/sociewiki/">
  <title>SocieWiki Recent Comments</title>
  <link>$url_base</link>
  <description>SocieWiki RecentComments</description>
  <items>

   <rdf:Seq>
   $rdf_li
   </rdf:Seq>

  </items>
 </channel>

$items

</rdf:RDF>

EOD;
    fwrite($fp, $out);
    fflush($fp);
    fclose($fp);
  }
}

function get_comment_firstlines($page, $num = RSS_COMMENT_LINE_NUMBER) {
  $comments = WikiCommentStorage::getComments($page);
  $last_comment = $comments[count($comments) - 1];
  $last_comment->unescape();
  $last_content = htmlspecialchars($last_comment->content);
  $lines = explode("\n", rtrim($last_content));
  $first_lines = array_slice($lines, 0, $num);
  return join("\n", $first_lines);
}

?>
