<?php

class Formatter {
  var $replaces1, $replaces2, $pages_pat;

  function Formatter() {
    global $manager;
    $this->replaces1 = array();
    $this->replaces2 = array();
    $pages_str = array_map("preg_quote", WikiPageStorage::existsPages());
    $users_str = array_map("preg_quote", $manager->accounts());
    $pages_str = array_unique(array_merge($pages_str, $users_str));
    usort($pages_str, array(&$this, "r_cmp_strlen"));
    $this->pages_pat = "/" . implode("|", $pages_str) . "/";
  }

  function clear() {
    $this->replaces1 = array();
    $this->replaces2 = array();
  }

  function formatSingleLine($text) { // for edit-memo and queue
    $result = htmlspecialchars($text);
    $result = $this->fixSpaces($result);
    $result = $this->makeLink($result);
    return $result;
  }

  function format($text) { // for comment 
    $result = htmlspecialchars($text);
    $result = $this->normalizeLineBreak($text);
    $result = $this->fixSpaces($result);
    $result = $this->makeLink($result);
    $result = $this->makeBreakLine($result);
    return $result;
  }

  function formatWikiPage($text, $pageName) {
    $result = htmlspecialchars($text);
    $result = $this->normalizeLineBreak($result);
    $result = $this->fixSpaces($result);
    $result = $this->makeLink($result);
    $result = $this->markDiff($pageName, $result);
    $result = $this->makeBreakLine($result);
    return $result;
  }

  function fixSpaces($text) {
    $result = $text;
    $result = str_replace("\t", "    ", $result);
    $result = preg_replace('/([ ]+)/e',
      '"<span style=\"font-family:monospace;\">".str_repeat("&nbsp;", strlen("\\1"))."</span>";',
      $result);
    return $result;
  }

  function makeBreakLine($text) {
    return preg_replace('/\n/', '<br>', $text);
  }

  function normalizeLineBreak($text) {
    $pattern = array("/\r\n/", "/\r/");
    $replace = array("\n", "\n");
    return preg_replace($pattern, $replace, $text);
  }

  function markDiff($pageName, $text) {
    $property = Property::instance();
    $diff = $property->get($pageName, 'diff');
    if ($diff) {
      $lines = explode("\n", $text);
      foreach (array_keys($diff) as $line_num) {
        $lines[$line_num] = '<ins>'.$lines[$line_num].'</ins>';
      }
      return join("\n", $lines);
    }
    return $text;
  }

  function makeLink($text) {
    $result = $text;
    $result = preg_replace_callback(URL_PAT, array(&$this,"urlAnchor"), $result);
    $result = preg_replace_callback($this->pages_pat, array(&$this,"wikiNameAnchor"), $result);
    $result = $this->insertAnchors($result, MARKER1, $this->replaces1);
    $result = $this->insertAnchors($result, MARKER2, $this->replaces2);
    $this->clear();
    return $result;
  }

  function insertAnchors($text, $marker, $replaces) {
    $arr = explode($marker, $text);
    if (count($arr) == 1) return $text;
    $result = array();
    for ($i = 0; $i < count($arr); $i++) {
      $result[] = $arr[$i];
      if (isset($replaces[$i])) $result[] = $replaces[$i];
    }
    return join("", $result);
  }

  function r_cmp_strlen($a, $b) {
    $la = strlen($a);
    $lb = strlen($b);

    if ($la == $lb) return 0;
    return $la > $lb ? -1 : 1;
  }

  function wikiNameAnchor($matches) {
    $raw = $matches[0];
    $encoded = urlencode($matches[0]);
    $this->replaces1[] = sprintf('<a href="index.php?mod=WikiView&name=%s">%s</a>',
				 $encoded, $raw);
    return MARKER1;
  }

  function urlAnchor($matches) {
    $str = $matches[0];
    $this->replaces2[] = sprintf('<a href="%s">%s</a>', $str, $str);
    return MARKER2;
  }

  // ---- STATIC FUNCTIONS ----

  function linkToPage($name, $str = "") {
    if ($str == "") {
      $escaped = htmlspecialchars($name);
    }
    else {
      $escaped = htmlspecialchars($str);
    }
    $encoded = htmlspecialchars(urlencode($name));
    return sprintf('<a href="index.php?mod=WikiView&name=%s">%s</a>', $encoded, $escaped);
  }

  function linkToPageComment($name, $str = "") {
    if ($str == "") {
      $escaped = htmlspecialchars($name);
    }
    else {
      $escaped = htmlspecialchars($str);
    }
    $encoded = htmlspecialchars(urlencode($name));
    return sprintf('<a href="index.php?mod=WikiView&name=%s#comment">%s</a>', $encoded, $escaped);
  }

  function linkToAllComment($name, $str = "") {
    if ($str == "") {
      $escaped = htmlspecialchars($name);
    }
    else {
      $escaped = htmlspecialchars($str);
    }
    $encoded = htmlspecialchars(urlencode($name));
    return sprintf('<a href="index.php?mod=AllComment&name=%s">%s</a>', $encoded, $escaped);
  }

  function linkToPageIfUserExists($name, $str = "") {
    global $manager;
    if ($manager->exists($name)) {
      return Formatter::linkToPage($name, $str);
    }
    else {
      return htmlspecialchars($name);
    }
  }
}

?>
