<?php
class MenuFormlet {
  function show() {
    if (WebSession::isLogined()) {
      $items = MenuFormlet::_userItems();
    }
    else {
      $items = MenuFormlet::_guestItems();
    }
    echo '<div class="menu"><form method="get" action="index.php">';
    $user = WebSession::loginUserName();
    if (WebSession::isLogined()) {
      printf('<a href="index.php?mod=Top">%s</a>', htmlspecialchars($user));
    }
    else {
      echo '<a href="index.php">Top</a>';
    }
    MenuFormlet::_showItems($items);
    echo "</form></div>";
  }
  function _guestItems() {
    return array('allpages', 'search', 'login');
  }
  function _userItems() {
    return array('allpages', 'search', 'logout', 'queue');
  }
  function _showItems($items) {
    for ($i = 0; $i < count($items); $i++) {
      echo " | ";
      MenuFormlet::_showItem($items[$i]);
    }
  }
  function _showItem($itemName) {

    switch ($itemName) {
    case 'login':
      MenuFormlet::_showLogin();
      break;
    case 'logout':
      MenuFormlet::_showLogout();
      break;
    case 'queue':
      MenuFormlet::_showQueueBox();
      break;
    case 'allpages':
      MenuFormlet::_showAllPages();
      break;
    case 'search':
      MenuFormlet::_showSearch();
      break;
    }
  }
  function _showLogin() {
    ?>
    <a href="index.php?mod=Login">login</a>
    <?php
  }
  function _showLogout() {
    ?>
    <a href="index.php?action=logout">logout</a>
    <?php
  }
  function _showQueueBox() {
    global $request;
    if (isset($request['name'])) {
      $name = htmlspecialchars($request['name']);
      echo "    <input type=\"hidden\" name=\"name\" value=\"$name\">\n";
    }
    ?>
    <input type="hidden" name="action" value="queue">
    <input type="hidden" name="cmd" value="add">
    <input type="submit" value="Queue in">
    <input type="text" name="item">
    <?php
  }
  function _showAllPages() {
    ?>
    <a href="index.php?mod=AllPages">all pages</a>
    <?php
  }
  function _showSearch() {
    ?>
    <a href="index.php?mod=Search">search</a>
    <?php
  }
}

class LoginFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="login">
       User name:<input type="text" name="user" value=""><br>
       password: <input type="password" name="pass" value=""><br>
       <input type="submit" value=" login ">
    </form>
    <?php
  }
  function action($params) {
    global $manager;
    $user = $params['user'];
    $pass = $params['pass'];
    if (!check_naming_rule($user)) {
      redirect_to("index.php?mod=Login", "ʥ桼̾Ǥ");
      exit;
    }
    $account = $manager->find($user);
    if ($account and WebSession::login($account, $pass)) {
      redirect_to("index.php", "󤷤ޤ");
    }
    else {
      redirect_to("index.php?mod=Login",
            "桼̾ѥɤ˸꤬ޤ");
    }
  }
}

class CreateAccountFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="account">
       <table>
       <tr><th>User name:<td><input type="text" name="user" value="">
       <tr><th>password:<td><input type="password" name="pass" value="">
       <tr><th> (again):<td><input type="password" name="again" value="">
       <tr><td colspan="2"><input type="submit" value=" create ">
       </table>
    </form>
    <?php
  }

  function action($params) {
    global $manager;
    $user = $params['user'];
    $pass = $params['pass'];
    $again = $params['again'];
    if ($manager->exists($user)) {
      redirect_to("index.php?mod=Account",
             "ϿΤ桼̾ΤϿǤޤǤ");
    }
    elseif (!check_naming_rule($user)) {
      redirect_to("index.php?mod=Account",
             "桼̾û뤫ޤϻѤǤʤʸޤޤƤ뤿ϿǤޤǤ");
    }
    elseif ($user == 'Guest') {
      redirect_to("index.php?mod=Account",
             "GuestȤ̾ϿǤޤ");
    }
    elseif ($pass != $again) {
      redirect_to("index.php?mod=Account",
             "ѥ԰פΤϿǤޤǤ");
    }
    else {
      $result = $manager->create($user, $pass);
      if ($result) {
        $account = $manager->find($user);
        WebSession::login($account, $pass);
        redirect_to("index.php", "Ͽޤ");
      }
      else {
        redirect_to("index.php", "Υ顼ΤϿǤޤǤ");
      }
    }
  }
}

class CreateAdminFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="createadmin">
       <table>
       <tr><th>User name:<td><input type="text" name="user" value="">
       <tr><th>password:<td><input type="password" name="pass" value="">
       <tr><th> (again):<td><input type="password" name="again" value="">
       <tr><td colspan="2"><input type="submit" value=" create ">
       </table>
    </form>
    <?php
  }

  function action($params) {
    global $manager;
	if (count($manager->accounts()) > 0) {
	  die("CA error 2");
	}
    $user = isset($params['user']) ? $params['user'] : "";
    $pass = isset($params['pass']) ? $params['pass'] : "";
    $again = isset($params['again']) ? $params['again'] : "";
	if ($pass == "" and $again == "") {
      redirect_to("index.php?mod=CreateAdmin",
             "ѥɤɬϤƲ");
	}
    elseif (!check_naming_rule($user)) {
      redirect_to("index.php?mod=CreateAdmin",
             "桼̾û뤫ޤϻѤǤʤʸޤޤƤ뤿ϿǤޤǤ");
    }
    elseif ($user == 'Guest') {
      redirect_to("index.php?mod=Account",
             "GuestȤ̾ϿǤޤ");
    }
    elseif ($pass != $again) {
      redirect_to("index.php?mod=Account",
             "ѥ԰פΤϿǤޤǤ");
    }
    else {
      $result = $manager->create($user, $pass);
      if ($result) {
        $account = $manager->find($user);
		$account->setConfig('admin', true);
		$manager->update($account);
        WebSession::login($account, $pass);
        redirect_to("index.php", "Ͽޤ");
      }
      else {
        redirect_to("index.php", "Υ顼ΤϿǤޤǤ");
      }
    }
  }
}

class AccountListFormlet {
  function show() {
    global $manager;
    $accounts = $manager->accounts();
    echo "<ul>\n";
    foreach ($accounts as $each) {
      $link = Formatter::linkToPage($each);
      echo '<li>', $link, "\n";
    }
    echo "</ul>\n";
  }
}

class StylesheetFormlet {
  function show() {
    global $manager;
    if (!WebSession::isLogined()) {
      $theme = DEFAULT_THEME;
    }
    elseif ($account = $manager->find(WebSession::loginUserName())) {
      $theme = $account->getConfig("theme");
      if (!$theme) $theme = DEFAULT_THEME;
    }
    else {
      $theme = DEFAULT_THEME;
    }
    $theme = htmlspecialchars($theme);
    $href = "theme/${theme}/${theme}.css";
    ?>
    <link rel="stylesheet" type="text/css" href="<?php echo $href ?>" />
    <?php
  }
}

class ChangePasswordFormlet {
  function show() {
    ?>
    <form method="post" action="index.php">
       <input type="hidden" name="action" value="changePassword">
       <table>
       <tr><td>old password:<td><input type="password" name="oldPass" value=""><br>
       <tr><td>new password:<td><input type="password" name="newPass" value=""><br>
       <tr><td>new password (confirm):<td><input type="password" name="again" value=""><br>
       <tr><td colspan="2"><input type="submit" value=" change ">
       </table>
    </form>
    <?php
  }

  function action($params) {
    if (!WebSession::isLogined()) {
      die("error");
    }
    global $manager;
    $oldPass = $params['oldPass'];
    $newPass = $params['newPass'];
    $again = $params['again'];
    if ($newPass != $again) {
      die("οѥϤ԰פǤ");
    }
    $account = $manager->find(WebSession::loginUserName());
    if ($account->changePassword($oldPass, $newPass)) {
      $manager->update($account);
      WebSession::login($account, $newPass);
      redirect_to("index.php", "ѥɤѹޤ");
    }
    else {
      redirect_to("index.php?mod=ChangePassword", "ѥɤ԰פΤѹǤޤǤ");
    }
  }
}

?>
