<?php

class CommentFormlet {

  function show($num=DEFAULT_COMMENT_NUMBER) {
    global $request;
    $page = $request['name'];
    CommentFormlet::showPage($page, $num);
  }

  function showPage($page, $num) {
    $comments = WikiCommentStorage::getComments($page);
    $i = 0;
    // if $num == 0, show all comments
    if (count($comments) > DEFAULT_COMMENT_NUMBER && $num != 0) {
      $i = count($comments) - $num;
      $comments = array_slice($comments, 0 - $num);
    }
    $formatter = new Formatter();
    foreach ($comments as $c) {
      $i++;
      CommentFormlet::printComment($c, $i, $formatter);
    }

    if (count($comments) > 0) {
      $lastComment = $comments[count($comments)-1];
      $user = WebSession::loginUserName();
      if (WebSession::isLogined()) {
	if ($user == $lastComment->name or $lastComment->name == "Guest") {
	  printf('<p><a href="index.php?mod=CommentEdit&amp;name=%s">Edit last comment</a></p>',
		 htmlspecialchars(urlencode($page)));
	}
      }
    }
    ?>
      <a name="comment"><form method="post" action="index.php"></a>
      <input type="hidden" name="action" value="comment">
      <input type="hidden" name="name" value="<?php echo $page ?>">
      <textarea name="content" cols="60" rows="3"></textarea><br>
      <input type="submit" value=" Post ">
      <?php if(!WebSession::isLogined()): ?>
       User̾=Guest Ƥޤ
      <?php endif; ?>
      </form>
    <?php
  }

  function printComment($comment, $num, $formatter) {
    $comment->unescape();
    $text = rtrim($comment->content);
    $text = htmlspecialchars($text);
    $text = $formatter->format($text);
      ?>
      <dl><dt>
	 <?php echo $num ?>
	 ̾<?php echo Formatter::linkToPageIfUserExists($comment->name) ?>
	 (<?php echo $comment->date ?>)</dt>
	 <dd><?php echo $text ?></dd></dl>
      <?php
  }

  function action($params) {
    $property = Property::instance();

    $pageName = $params['name'];
    $userName = WebSession::loginUserName();
    $content = $params["content"];

    $date = date("Y-m-d H:i:s");
    $comment = new Comment($date, $userName, $content);
    WikiCommentStorage::appendComment($comment, $pageName);
    $property->set($pageName, 'last_commented_user', WebSession::loginUserName());
    Rss::writeRecentComments();
    $escaped = htmlspecialchars(urlencode($pageName));
    redirect_to("index.php?mod=WikiView&name=$escaped#comment",
		"ȤƤޤ", 0);
  }
}

class Comment {
  var $date, $name, $content;
  function Comment($date, $name, $content) {
    $this->date = $date;
    $this->name = $name;
    $this->content = $content;
  }

  function unescape() {
    $match = array("/~~/", "/~%/", "/".chr(255)."/");
    $replace = array(chr(255), "\n", "~");
    $this->content = preg_replace($match, $replace, $this->content);
  }

  function escape() {
    $match = array("/\r\n/", "/\r/", '/~/', '/\\n/');
    $replace = array("\n", "", '~~', '~%');
    $this->content = preg_replace($match, $replace, $this->content);
  }

}

class CommentEditFormlet {
  function show() {
    global $request;
    check_pagename($request["name"]);
    $page = $request['name'];
    $comments = WikiCommentStorage::getComments($page);
    $lastComment = $comments[count($comments)-1];
    $userName = WebSession::loginUserName();
    if ($lastComment->name != $userName && $lastComment->name != "Guest") {
      echo 'error.';
      exit;
    }
    $lastComment->unescape();
    $text = rtrim($lastComment->content);
    $text = htmlspecialchars($text);
    ?>
      <form method="post" action="index.php"></a>
      <input type="hidden" name="action" value="lastCommentEdit">
      <input type="hidden" name="name" value="<?php echo $page ?>">
      <textarea name="content" cols="60" rows="10"><?php echo $text ?></textarea><br>
      <input type="submit" value=" Post ">
      </form>
    <?php
  }

  function action($params) {
    global $request;
    check_pagename($request["name"]);
    $userName = WebSession::loginUserName();
    $pageName = $request['name'];
    $comments = WikiCommentStorage::getComments($pageName);
    $lastComment = $comments[count($comments)-1];
    if ($lastComment->name != $userName && $lastComment->name != "Guest") {
      echo 'error.';
      exit;
    }
    $content = $params["content"];
    $property = Property::instance();
    if ($content == "") {
      if (count($comments) == 1) {
        unlink(WikiCommentStorage::filePath($pageName));
      }
      else {
        array_pop($comments);
        $lastComment = $comments[count($comments)-1];
        $time = CommentEditFormlet::parseDateTime($lastComment->date);
        WikiCommentStorage::writeComments($pageName, $comments);
        touch(WikiCommentStorage::filePath($pageName), $time);
        $property->set($pageName, 'last_commented_user', $lastComment->name);
      }
    }
    else {
      $date = date("Y-m-d H:i:s");
      $newComment = new Comment($date, $userName, $content);
      $newComment->escape();
      $comments[count($comments)-1] = $newComment;
      WikiCommentStorage::writeComments($pageName, $comments);
      $property->set($pageName, 'last_commented_user', WebSession::loginUserName());
    }
    Rss::writeRecentComments();
    $url = sprintf("index.php?mod=WikiView&name=%s#comment", htmlspecialchars(urlencode($pageName)));
    if ($content == "") {
      redirect_to($url, "Ȥޤ", 1);
    }
    else {
      redirect_to($url, "Ȥޤ", 1);
    }
  }

  function parseDateTime($str) {
    list($d, $t) = explode(" ", $str);
    list($Y, $M, $D) = explode("-", $d);
    list($h, $m, $s) = explode(":", $t);
    return mktime($h, $m, $s, $M, $D, $Y);
  }
}

?>
