<?php
class CalendarFormlet {

  function show() {
    list($year, $month) = CalendarFormlet::getParam();

    $formatter = new Formatter();
    $plans = CalendarFormlet::getPersonalPlans();

    $firstday = date("w", mktime(0, 0, 0, $month, 1, $year));
    $lastday = date("t", mktime(0, 0, 0, $month, 1, $year));
    $lastblank = 7 - (($firstday + $lastday) % 7);
    if($lastblank == 7) $lastblank = 0;

    $html = array();
    $html[] = CalendarFormlet::skipLastMonthDays($firstday);
    for($day = 1; $day <= $lastday; $day++){
      $html[] = CalendarFormlet::setHolidayStyle($year, $month, $day);
      $html[] = CalendarFormlet::makeDayNumber($year, $month, $day);
      $html[] = CalendarFormlet::makeDayContent($year, $month, $day, $plans, $formatter);
      $html[] = "</td>";
      if(($day + $firstday) % 7 == 0){
	$html[] = "</tr>\n<tr>";
      }
    }
    $html[] = CalendarFormlet::skipNextMonthDays($lastblank);
    print implode("", $html);
  }

  function showCalendarHeader(){
    list($year, $month) = CalendarFormlet::getParam();

    $prev_year=date("Y",mktime(0,0,0,$month-1,1,$year));
    $prev_month=date("m",mktime(0,0,0,$month-1,1,$year));
    $next_year=date("Y",mktime(0,0,0,$month+1,1,$year));
    $next_month=date("m",mktime(0,0,0,$month+1,1,$year));

    $link = '[<a href="index.php?mod=FormletLauncher&amp;formlet=Calendar&amp;'.
      'year=%s&amp;month=%s">%s</a>]';

    print "Calendar: {$year}-{$month}  ";
    printf($link, $prev_year, $prev_month, "Prev");
    printf($link, $next_year, $next_month, "Next");
  }

  function getParam() {
    global $request;
    if(isset($request['year'])) {
      $year = $request['year'];
    }
    else {
      $year = date("Y",time());
    }
    if(isset($request['month'])) {
      $month = $request['month'];
    }
    else {
      $month = date("m",time());
    }
    return array($year, $month);
  }


  function userCalendarPage() {
    return WebSession::loginUserName()."Plan";
  }

  function skipLastMonthDays($firstday) {
    $result = array();
    for($i = 0; $i < $firstday; $i++){
      $result[] = "<td><br></td>";
    }
    return implode("", $result);
  }

  function skipNextMonthDays($lastblank) {
    $result = array();
    for($i = 0; $i < $lastblank; $i++){
      $result[] = "<td><br></td>";
    }
    return implode("", $result);
  }

  function setHolidayStyle($year, $month, $day) {
    $holiday = Calendar::checkHoliday($year, $month, $day);

    switch ($holiday) {
    case 0:
      return '<td style="vertical-align:top">';
    case 1:
      return '<td style="vertical-align:top" class="sunday">';
    case 2:
      return '<td style="vertical-align:top" class="saturday">';
    }
  }

  function makeDayNumber($year, $month, $day) {
    $day_html = sprintf('<a href="index.php?mod=WikiView&amp;name=Y%04dM%02dD%02d">%s</a>',
			$year, $month, $day, $day);
    if(CalendarFormlet::isToday($year, $month, $day)) {
      return "<span style='font-size:150%;font-weight: bold'>$day_html</span><br>";
    }
    else {
      return "$day_html<br>";
    }
  }

  function isToday($year, $month, $day) {
    $t = time();
    return $year == date("Y", $t) && $month == date("m", $t) && $day == date("d", $t);
  }

  function makeDayContent($year, $month, $day, $plans, $formatter) {
    $plan = CalendarFormlet::getDayPlan($year, $month, $day, $plans);
    $page = CalendarFormlet::getDayPage($year, $month, $day, $formatter);
    ($plan != "" && $page != "") ? $sep = "<hr>" : $sep = "";
    return $plan . $sep . $page;
  }

  function getDayPlan($year, $month, $day, $plans) {
    $result = array();

    $date_pat = "/^" . preg_quote(sprintf("%04d-%02d-%02d", $year, $month, $day), "/") . ":/";
    $hits = preg_grep($date_pat, $plans);
    if (count($hits) == 0) return "";

    foreach($hits as $plan){
      preg_match("/^\d{4}\-\d\{2}-\d{2}:\s*(.*)$/", $plan, $matches);
      $result[] = $matches[1];
    }
    return $result[] = '<span style="color:darkblue">'.implode("<br>", $result).'</span><br>';
  }

  function getPersonalPlans() {
    $pageName = CalendarFormlet::userCalendarPage();
    $text = WikiPageStorage::get($pageName);
    $plans = split("\n",htmlspecialchars($text));
    return $plans;
  }


  function getDayPage($year, $month, $day, &$formatter) {
    $pageName = CalendarFormlet::dayPageName($year, $month, $day);
    $text = WikiPageStorage::get($pageName);
    if ($text == "") return "";

    $html = $formatter->format($text);
    return $html;
  }

  function dayPageName($year, $month, $day) {
    return sprintf("Y%04dM%02dD%02d", $year, $month, $day);
  }
}

class Calendar {
  function checkHoliday($year, $mon, $day){
    $time = mktime(0, 0, 0, $mon, $day, $year); 

    //ꤹ롣
    $today = sprintf("%02d", $mon).sprintf("%02d", $day);
    $youbi = date("w", $time);
    $order = (int)(($day-1) / 7) + 1;
    //ꤹ롣
    $y_time = mktime(0, 0, 0, $mon, $day-1, $year); 
    $yesterday = date("m", $y_time).date("d", $y_time);
    $y_youbi = date("w", $y_time);
    $y_order = (int)((date("j", $y_time) - 1) / 7) + 1;
    $y_flag = 0;
    //ꤹ
    $t_time = mktime(0, 0, 0, $mon, $day+1, $year); 
    $tomorrow = date("m",$t_time).date("d", $t_time);
    $t_youbi = date("w", $t_time);
    $t_order = (int)((date("j", $t_time) - 1) / 7) + 1;
    $t_flag = 0;

    //ɤå
    if($youbi == 0) {return 1;}

    //դޤäƤ
    if($year <= 2002) {
      $fix_horidays = array('0101', '0211', '0321', '0429', '0503', '0505',
			    '0720', '0915', '0923', '1103', '1123', '1223');
    } else {
      $fix_horidays = array('0101', '0211', '0320', '0429', '0503', '0505',
			    '0923', '1103', '1123', '1223');
    }

    //ʬ/ʬɲáǯˤäѲ2000-2011ޤб
    if($year == 2000 or $year == 2001 or 
       $year == 2004 or $year == 2005 or 
       $year == 2008 or $year == 2009){
      array_push($fix_horidays, '0320', '0923');
    }elseif($year == 2002 or $year == 2003 or 
	    $year == 2006 or $year == 2007 or 
	    $year == 2010 or $year == 2011){
      array_push($fix_horidays, '0321', '0923');
    }

    //ɤå
    if(preg_grep("/^$today$/", $fix_horidays)) {return 1;}

    //ưɤå
    //  ͤ 裲
    //  ΰ 裲
    //  2003ǯʹߤϡäơ
    //     裳
    //  Ϸ 裳
    if($mon == '1' && $youbi == 1 && $order == 2) {return 1;}
    if($mon == '10' && $youbi == 1 && $order == 2) {return 1;}
    if($year >= 2003) {
      if($mon == '7' && $youbi == 1 && $order == 3) {return 1;}
      if($mon == '9' && $youbi == 1 && $order == 3) {return 1;}
    }

    //ɤå
    if(preg_grep("/^$yesterday$/", $fix_horidays)) {$y_flag = 1;}
    //ưɤå
    $y_mon = substr($yesterday, 0, 2);
    if($y_mon == '1' && $y_youbi == 1 && $y_order == 2) {$y_flag = 1;}
    if($y_mon == '10' && $y_youbi == 1 && $y_order == 2) {$y_flag = 1;}
    if($year >= 2003) {
      if($y_mon == '7' && $y_youbi == 1 && $y_order == 3) {$y_flag = 1;}
      if($y_mon == '9' && $y_youbi == 1 && $y_order == 3) {$y_flag = 1;}
    }
    //ǡĺξˤϡϵ
    if($y_flag == 1 && $y_youbi == 0) {return 1;}

    //ɤå
    if(preg_grep("/^$tomorrow$/", $fix_horidays)) {$t_flag = 1;}
    //ưɤå
    $t_mon = substr($tomorrow, 0, 2);
    if($t_mon == '1' && $t_youbi == 1 && $t_order == 2) {$t_flag = 1;}
    if($t_mon == '10' && $t_youbi == 1 && $t_order == 2) {$t_flag = 1;}
    if($year >= 2003) {
      if($t_mon == '7' && $t_youbi == 1 && $t_order == 3) {$t_flag = 1;}
      if($t_mon == '9' && $t_youbi == 1 && $t_order == 3) {$t_flag = 1;}
    }

    //Ȥ˽ξˤϡϵ
    if($y_flag && $t_flag) {return 1;}

    //ɤå
    if($youbi == 6) {return 2;}

    //ʾΥåˤҤäʤä顢Ǥʤ
    return 0;
  }
}
?>
