<?php //$Id: storage.php,v 1.18 2005/01/09 15:57:15 cake Exp $

function fwrite_safe($name, $text) {
  $tmp = tempnam(TMP_DIR, "TMP");
  $tmpfp = fopen($tmp, "w") or die("temporary file open error: $tmp");
  fwrite($tmpfp, $text, strlen($text));
  fflush($tmpfp);
  fclose($tmpfp);
  unlink($name) && rename($tmp, $name);
  chmod($name, 0666);
}


class Storage {
  function get($name) {
    if (file_exists(Storage::fileName($name))) {
      $text = file(Storage::fileName($name));
      $text = str_replace("\r", "", $text);
      $text = join("", $text);
      return $text;
    }
    else {
      return "new page";
    }
  }

  function put($name, $text, $memo, $isSage) {
    global $property;
    Storage::makeBackupDir($name);
    if (file_exists(Storage::fileName($name))) {
      clearstatcache();
      if ($isSage) {
	$oldText = Storage::getLastBackup($name);
	$lastTimestamp = filemtime(Storage::fileName($name));
      }
      else {
	$oldText = Storage::get($name);
	$oldMemo = $property->get($name, 'edit_memo');
	Storage::saveHistory($name, $oldMemo);
	Storage::backupOld($name);
      }
      $diff = Storage::computeDifference($text, $oldText);
      $isFirst = false;
    }
    else {
      $diff = array();
      $isFirst = true;
    }
    Storage::putNew($name, $text);
    if ($isSage) {
      touch(Storage::fileName($name), $lastTimestamp);
    }
    clearstatcache();
    Storage::setMetaData($name, $isFirst, $diff, $memo);
    Rss::writeRecentChanges();
  }

  function getLastBackup($name) {
    $lastHistory = Storage::lastHistory($name);
    $timestamp = $lastHistory[3];
    if ($timestamp) {
      $path = Storage::backupFilePath($name, $timestamp);
      $text = Storage::getBackupFile($path);
      return $text;
    }
    else {
      return "";
    }
  }
  function backupFilePath($name, $timestamp) {
    $filename = preg_replace("/(........)(......)/", '\1-\2.txt', $timestamp);
    $path = METADATA_DIR.$name."/".$filename;
    return $path;
  }
  function getBackupFile($path) {
    $fp = fopen($path, "r") or die("backup file open error: $path");
    $text = fread($fp, filesize($path));
    fclose($fp);
    return $text;
  }

  function setMetaData($name, $isFirst, $diff, $memo) {
    global $property;
    $user = WebSession::loginUserName();
    $property->set($name, 'last_modified_user', $user);
    if ($isFirst) {
      $property->set($name, 'creator', $user);
    }
    $property->set($name, 'diff', $diff);
	$property->set($name, 'edit_memo', $memo);
  }

  function saveHistory($name, $memo) {
    $date = date("YmdHis", filemtime(Storage::fileName($name)));
    $user = WebSession::loginUserName();

    $path = Storage::historyFileName($name);
    $fp = fopen($path, "a") or die("file open error: edit history file ($path)");
    fwrite($fp, sprintf("%s\t%s\t%s\n", $date, $user, $memo));
    fflush($fp);
    fclose($fp);
  }

  function computeDifference($new, $old) {
    $newArray = explode("\n", Formatter::normalizeLineBreak($new));
    $oldArray = explode("\n", Formatter::normalizeLineBreak($old));
    $diff = array_diff($newArray, $oldArray);
    return $diff;
  }
  
  function putNew($name, $text) {
    $text = Formatter::normalizeLineBreak($text);
    $file = Storage::fileName($name);
    $fp = fopen($file,'w') or die("file open error");
    fputs($fp,$text);
    fflush($fp);
    fclose($fp);
  }

  function fileName($name) {
    Storage::checkSlash($name);
    return DATA_DIR.$name.".txt";
  }

  function backupOld($name) {
    $src = Storage::fileName($name);
    $dest = Storage::backupName($name);
    rename($src, $dest);
  }

  function makeBackupDir($name) {
    Storage::checkSlash($name);
    $dir = METADATA_DIR.$name;
    if (!file_exists($dir)) {
      mkdir($dir, 0777);
    }
  }

  function backupName($name) {
    Storage::checkSlash($name);
    $dir = METADATA_DIR.$name;
    return $dir."/".date("Ymd-His", filemtime(Storage::fileName($name))).".txt";
  }

  function recentChanges($num) {
    global $property;
    $files = Storage::pageFiles();
    usort($files, array("Storage","cmpRecent"));
    $result = array();
    // if arg $num is zero, retrieve all pages
    if ($num == 0) $num = count($files);
    foreach (array_slice($files, 0, $num) as $file) {
      $wikiname = preg_replace("/\.txt$/", "", $file);
      $time = date("Y-m-d H:i:s", filemtime(DATA_DIR.$file));
      $user = $property->get($wikiname, 'last_modified_user');
      $result[] = array($time, $wikiname, $user);
    }
    return $result;
  }

  function pageFiles() {
    $handle = opendir(DATA_DIR) or die("data dir open error");
    $files = array();
    while (false !== ($file = readdir($handle))) {
      if (preg_match("/\.txt$/", $file)) {
	$files[] = $file;
      }
    }
    return $files;
  }

  function recentComments($num) {
    global $property;
    $files = Storage::commentFiles();
    usort($files, array("Storage","cmpRecent"));
    $result = array();
    // if arg $num is zero, retrieve all pages
    if ($num == 0) $num = count($files);
    foreach (array_slice($files, 0, $num) as $file) {
      $wikiname = preg_replace("/\.cmt$/", "", $file);
      $time = date("Y-m-d H:i:s", filemtime(DATA_DIR.$file));
      $user = $property->get($wikiname, 'last_commented_user');
      $result[] = array($time, $wikiname, $user);
    }
    return $result;
  }

  function commentFiles() {
    $handle = opendir(DATA_DIR) or die("data dir open error");
    $files = array();
    while (false !== ($file = readdir($handle))) {
      if (preg_match("/\.cmt$/", $file)) {
	$files[] = $file;
      }
    }
    return $files;
  }

  function cmpRecent($a, $b) {
    $at = filemtime(DATA_DIR.$a);
    $bt = filemtime(DATA_DIR.$b);
    if ($at == $bt) return 0;
    return $at > $bt ? -1 : 1;
  }

  function editHisoty($name) {
    $path = Storage::historyFileName($name);
    $result = array();
    if (!file_exists($path)) return $result;
    $lines = file($path);
    rsort($lines);
    foreach ($lines as $line) {
      list($timestamp, $user, $memo) = split("\t", $line);
      $date = preg_replace('/(\d{4})(\d{2})(\d{2})(\d{2})(\d{2})(\d{2})/',
			   '\1-\2-\3 \4:\5:\6', $timestamp);
      $result[] = array($date, $user, rtrim($memo), $timestamp);
    }
    return $result;
  }

  function lastHistory($name) {
    $histories = Storage::editHisoty($name);
    $i = count($histories);
    if ($i > 1) {
      return $histories[0];
    }
    else {
      return array(null, null, null, null);
    }
  }

  function historyFileName($name) {
    Storage::checkSlash($name);
    return METADATA_DIR.$name."/history.txt";
  }

  function checkSlash($name) {
    preg_match("{/}", $name) and die("invalid name:".htmlspecialchars($name));
  }

}

class HashDB {
  var $hash;
  function HashDB($path) {
    $this->path = $path;
    $this->hash = array();
    if (!file_exists($path)) {
      $this->init();
      echo "database initialize";
    }
  }
  function init() {
    $fp = fopen($this->path, "w") or die("database initialization error");
    fflush($fp);
    fclose($fp);
  }
  function exists($key) {
    $this->begin();
    return isset($this->hash[$key]);
  }
  function insert($key, $val) {
    $this->begin();
    if ($this->exists($key)) { return false; }
    $this->hash[$key] = $val;
    $this->commit();
    return true;
  }
  function update($key, $val) {
    $this->begin();
    if (!$this->exists($key)) return false;
    $this->hash[$key] = $val;
    $this->commit();
    return true;
  }
  function fetch($key) {
    $this->begin();
    return $this->hash[$key];
  }
  function keys() {
    $this->begin();
    return array_keys($this->hash);
  }
  function delete($key) {
    $this->begin();
    if (!$this->exists($key)) return false;
    unset($this->hash[$key]);
    $this->commit();
    return true;
  }

  function begin() {
    clearstatcache();
    $fp = fopen($this->path, "r");
    $buf = fread($fp, filesize($this->path));
    fclose($fp);
    if (strlen($buf)) $hash = unserialize($buf);
    else $hash = array();
    $this->hash = $hash;
  }
  function commit() {
    $buf = serialize($this->hash);
    $path = $this->path;
    fwrite_safe($path, $buf);
  }
}

class Property {
  var $db;

  function Property($db) {
    $this->db = $db;
  }

  function get($page, $key) {
    if ($this->db->exists($page)) {
      $hash = $this->db->fetch($page);
      return $hash[$key];
    }
    else {
      return null;
    }
  }

  function set($page, $key, $value) {
    if ($this->db->exists($page)) {
      $hash = $this->db->fetch($page);
      $hash[$key] = $value;
      $this->db->update($page, $hash);
    }
    else {
      $hash = array();
      $hash[$key] = $value;
      $this->db->insert($page, $hash);
    }
  }
}

class Queue {
  function add($params) {
    $item = $params['item'];
    $pageName = $params['name'];
    if ($pageName) {
      $item = $item." ($pageName)";
    }
    $name = WebSession::loginUserName();
    if (isset($params['top'])) {
      Queue::pushToList($name, $item);
    }
    else {
      Queue::appendToList($name, $item);
    }
    redirect_to("index.php", "Queueɲäޤ", 0);
  }
  function age($name, $pos) {
    $item = Queue::removeFromList($name, $pos);
    Queue::pushToList($name, $item);
    redirect_to("index.php", "ƥưޤ", 0);
  }
  function sage($name, $pos) {
    $item = Queue::removeFromList($name, $pos);
    Queue::appendToList($name, $item);
    redirect_to("index.php", "ƥưޤ", 0);
  }
  function ok($name, $pos) {
    $item = Queue::removeFromList($name, $pos);
    Queue::writeLog($name, $item);
    redirect_to("index.php", "ƥλˤޤ", 0);
  }
  function del($name, $pos) {
    Queue::removeFromList($name, $pos);
    redirect_to("index.php", "ƥޤ", 0);
  }

  function pushToList($name, $item) {
    $item = rtrim($item)."\n";
    $lines = file(Queue::fileName($name));
    array_unshift($lines, $item);
    Queue::updateList($name, $lines);
  }

  function appendToList($name, $item) {
    $item = rtrim($item)."\n";
    $lines = file(Queue::fileName($name));
    array_push($lines, $item);
    Queue::updateList($name, $lines);
  }

  function removeFromList($name, $pos) {
    $lines = file(Queue::fileName($name));
    list($removed) = array_splice($lines, $pos, 1);
    Queue::updateList($name, $lines);
    return $removed;
  }

  function updateList($name, $lines) {
    $target = Queue::fileName($name);
    $text = join("", $lines);
    fwrite_safe($target, $text);
  }

  function writeLog($name, $item) {
    $message = Queue::withTimeStamp($item);
    $target = Queue::logFileName($name);
    Queue::writeLogFile($target, $message);
  }

  function writeLogFile($target, $message) {
    $old = file($target);
    $new = Queue::addAndSuppless($old, $message);
    $text = join("", $new);
    fwrite_safe($target, $text);
  }

  function addAndSuppless($lines, $message) {
    array_push($lines, $message);
    if (count($lines) > QUEUE_MAX_LOG_SIZE) {
      array_splice($lines, 0, count($lines) - QUEUE_MAX_LOG_SIZE);
    }
    return $lines;
  }

  function removeFromLog($name, $dels) {
    $target = Queue::logFileName($name);
    $lines = file($target);
    $result = array();
    for ($i = 0; $i < count($lines); $i++) {
      if (!in_array($i, $dels)) {
	$result[] = $lines[$i];
      }
    }
    $text = join("", $result);
    fwrite_safe($target, $text);
  }

  function withTimeStamp($item) {
    $item = rtrim($item)."\n";
    $date = date("Y\tm\td\tH\ti\ts\t");
    return $date.$item;
  }

  function items($name) {
    $target = Queue::fileName($name);
    $lines = file($target);
    return $lines;
  }

  function logs($name) {
    $target = Queue::logFileName($name);
    $lines = file($target);
    return $lines;
  }

  function paramError() {
    die("param error");
  }

  function fileName($name) {
    return Queue::path($name, "queue.txt");
  }

  function logFileName($name) {
    return Queue::path($name, "quelog.txt");
  }

  function path($name, $suffix) {
    Storage::checkSlash($name);
    Storage::makeBackupDir($name);
    $path = METADATA_DIR.$name."/".$suffix;
    if (!file_exists($path))
      touch($path);
    return $path;
  }
}

?>
