<?php

class Rss {
  function writeRecentChanges() {
    $url_base = URL_BASE;
    $items = array();
    $rdf_li = array();
    foreach (Storage::recentChanges(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($time, $wikiname, $user) = $item;
      $dc_date = preg_replace("/ /", "T", $time)."+9:00";
      $link = $url_base."index.php?mod=WikiView&amp;name=".$wikiname;
      $rdf_li[] = "<rdf:li rdf:resource=\"$link\" />\n";
      $items[] = <<<EOD
<item rdf:about="$link">
 <title>$wikiname</title>
 <link>$link</link>
 <dc:date>$dc_date</dc:date>
 <description>by $user</description>
</item>

EOD;
    }
    $items = join("", $items);
    $rdf_li = join("", $rdf_li);
    $fp = @fopen(RECENT_CHANGES_RSS_PATH, "w");
    if (!$fp) return;
    $out = <<<EOD
<?xml version="1.0" encoding="utf-8"?>

<rdf:RDF 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns="http://purl.org/rss/1.0/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
  xml:lang="ja">

 <channel rdf:about="http://cake.dyndns.org/sociewiki/">
  <title>SocieWiki Recent Changes</title>
  <link>$url_base</link>
  <description>SocieWiki RecentChanges</description>
  <items>

   <rdf:Seq>
   $rdf_li
   </rdf:Seq>

  </items>
 </channel>

$items

</rdf:RDF>

EOD;
    fwrite($fp, $out);
    fflush($fp);
    fclose($fp);
  }


  function writeRecentComments() {
    $url_base = URL_BASE;
    $items = array();
    $rdf_li = array();
    foreach (Storage::recentComments(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($time, $wikiname, $user) = $item;
      $dc_date = preg_replace("/ /", "T", $time)."+9:00";
      $link = $url_base."index.php?mod=WikiView&amp;name=".$wikiname."#comment";
      $rdf_li[] = "<rdf:li rdf:resource=\"$link\" />\n";
      $items[] = <<<EOD
<item rdf:about="$link">
 <title>$wikiname</title>
 <link>$link</link>
 <dc:date>$dc_date</dc:date>
 <description>by $user</description>
</item>

EOD;
    }
    $items = join("", $items);
    $rdf_li = join("", $rdf_li);
    $fp = @fopen(RECENT_COMMENTS_RSS_PATH, "w");
    if (!$fp) return;
    $out = <<<EOD
<?xml version="1.0" encoding="utf-8"?>

<rdf:RDF 
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns="http://purl.org/rss/1.0/"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
  xml:lang="ja">

 <channel rdf:about="http://cake.dyndns.org/sociewiki/">
  <title>SocieWiki Recent Comments</title>
  <link>$url_base</link>
  <description>SocieWiki RecentComments</description>
  <items>

   <rdf:Seq>
   $rdf_li
   </rdf:Seq>

  </items>
 </channel>

$items

</rdf:RDF>

EOD;
    fwrite($fp, $out);
    fflush($fp);
    fclose($fp);
  }
}
?>