<?php

class Formatter {
  var $replaces, $r2;

  function Formatter() {
    $this->replaces = array();
  }

  function format($text) { // for comment and queue
    $result = $text;
    $result = $this->normalizeLineBreak($text);
    $result = $this->makeLink($result);
    $result = $this->softIndent($result);
    $result = $this->breakLine($result);
    return $result;
  }

  function formatWikiPage($text, $pageName) {
    $result = $text;
    $result = $this->normalizeLineBreak($result);
    $result = $this->softIndent($result);
    $result = $this->makeLink($result);
    $result = $this->markDiff($pageName, $result);
    $result = $this->breakLine($result);
    return $result;
  }

  function softIndent($text) {
    return preg_replace('/^([ ]+)/me', 'str_repeat("&nbsp;", strlen("\\1"));', $text);
  }

  function breakLine($text) {
    return preg_replace('/$/m', '<br>', $text);
  }

  function normalizeLineBreak($text) {
    $pattern = array("/\r\n/", "/\r/");
    $replace = array("\n", "\n");
    return preg_replace($pattern, $replace, $text);
  }

  function markDiff($pageName, $text) {
    global $property;
    $diff = $property->get($pageName, 'diff');
    if ($diff) {
      $lines = explode("\n", $text);
      foreach (array_keys($diff) as $line_num) {
        $lines[$line_num] = '<ins>'.$lines[$line_num].'</ins>';
      }
      return join("\n", $lines);
    }
    return $text;
  }

  function makeLink($text) {
    $ret = preg_replace_callback(URL_PAT, array(&$this,"urlAnchor"), $text);
    $ret = preg_replace_callback(WIKINAME_PAT, array(&$this,"wikiNameAnchor"), $ret);
    $arr = explode(MARKER, $ret);
    $result = array();
    for ($i = 0; $i < count($arr); $i++) {
      $result[] = $arr[$i];
      if (isset($this->replace[$i]))
	$result[] = $this->replace[$i];
    }
    return join("", $result);
  }

  function wikiNameAnchor($matches) {
    $str = htmlspecialchars($matches[0]);
    return  sprintf('<a href="index.php?mod=WikiView&name=%s">%s</a>',
			       $str, $str);
  }

  function urlAnchor($matches) {
    $str = $matches[0];
    $this->replace[] =  sprintf('<a href="%s">%s</a>', $str, $str);
    return MARKER;
  }

  // ---- STATIC FUNCTIONS ----
  function wikiName($str) {
    $result = preg_replace_callback(WIKINAME_PAT, array("Formatter","asAnchor"), $str);
    return $result;
  }
  function asAnchor($matches) {
    $wikiname = $matches[0];
    return sprintf('<a href="index.php?mod=WikiView&name=%s">%s</a>',
		   htmlspecialchars($wikiname), htmlspecialchars($wikiname));
  }

  function wikiNameComment($str) {
    $result = preg_replace_callback(WIKINAME_PAT, array("Formatter","asAnchorComment"), $str);
    return $result;
  }
  function asAnchorComment($matches) {
    $wikiname = $matches[0];
    return sprintf('<a href="index.php?mod=WikiView&name=%s#comment">%s</a>',
		   htmlspecialchars($wikiname), htmlspecialchars($wikiname));
  }
}

?>
