<?php
require_once 'resources/config.php';
require_once 'formlet/core.frm.php';
require_once 'formlet/wiki.frm.php';
require_once 'formlet/comment.frm.php';
require_once 'formlet/queue.frm.php';
require_once 'formlet/watch.frm.php';
require_once 'formlet/userconf.frm.php';
require_once 'lib/session.php';
require_once 'lib/storage.php';
require_once 'lib/account.php';
require_once 'lib/formatter.php';
require_once 'lib/rss.php';

$db = new HashDB("metadata/accounts.hash");
$manager = new AccountManager($db);

$pdb = new HashDB("metadata/property.hash");
$property = new Property($pdb);

WebSession::start();
set_request();

if ($method == 'GET' && isset($request['mod'])) {
  switch ($request['mod']) {
  case 'Top':
    apply_template('Top', 'Site top');
    break;
  case 'Login':
    apply_template('Login', 'Login page');
    break;
  case 'Account':
    apply_template('Account', 'Account registration');
    break;
  case 'WikiEdit':
    check_logined();
    check_wikiname($request["name"]);
    apply_template('WikiEdit', 'Edit: '.$request["name"]);
    break;
  case 'WikiView':
    check_wikiname($request["name"]);
    apply_template('WikiView', $request["name"]);
    break;
  case 'WikiHistory':
    check_wikiname($request["name"]);
    apply_template('WikiHistory', $request["name"]);
    break;
  case 'WikiVersion':
    check_wikiname($request["name"]);
    apply_template('WikiVersion', "old version of ".$request["name"]);
    break;
  case 'QueueLogEdit':
    check_logined();
    apply_template('QueueLogEdit', "QueueList log edit");
    break;
  case 'AllComment':
    apply_template('AllComment', "All Comment of ".$request["name"]);
    break;
  case 'WatchListEdit':
    check_logined();
    apply_template('WatchListEdit', "Watch List Edit");
    break;
  case 'WatchList':
    check_logined();
    apply_template('WatchList', "Watch List");
    break;
  case 'AllPages':
    apply_template('AllPages', "All pages");
    break;
  case 'UserConf':
    check_logined();
    apply_template('UserConf', "User configuration");
    break;
  default:
    print "error";
    break;
  }
}

elseif (isset($request['action'])) {
  switch ($request['action']) {
  case 'search':
    SearchFormlet::action($request);
    break;
  case 'login':
    LoginFormlet::action($request);
    break;
  case 'logout':
    check_logined();
    WebSession::logout();
    redirect_to("index.php", "Ȥޤ");
    break;
  case 'account':
    CreateAccountFormlet::action($request);
    break;
  case 'wikiedit':
    check_logined();
    check_wikiname($request["name"]);
    WikiEditFormlet::action($request);
    break;
  case 'comment':
    check_wikiname($request["name"]);
    CommentFormlet::action($request);
    break;
  case 'queue':
    check_logined();
    QueueListFormlet::action($request);
    break;
  case 'queuelogedit':
    check_logined();
    QueueLogEditFormlet::action($request);
    break;
  case 'watchlistedit':
    check_logined();
    WatchListEditFormlet::action($request);
    break;
  case 'formletedit':
    check_logined();
    FormletEditFormlet::action($request);
    break;
  case 'addtowatchlist':
    check_logined();
    WatchListAddFormlet::action($request);
    break;
  case 'themechoose':
    check_logined();
    ThemechooseFormlet::action($request);
    break;
  default:
    redirect_to("index.php", "action error");
    break;
  }
}
else {
  apply_template('Top', 'Site top');
}

// end of main
exit;

function apply_template($mod, $title) {
  global $session, $manager, $request;
  $module = 'module/'.$mod.'.mod.php';
  include 'resources/skin.html.php';
}


function redirect_to($url, $mes, $int = 2) {
  ?>
  <html>
  <meta http-equiv="Content-Type" content="text/html; charset=euc-jp">
  <meta http-equiv="Refresh" content="<?php echo $int ?>;URL=<?php echo $url ?>">
  <p><?php echo $mes ?><br><a href="<?php echo $url ?>">Back</a></p>
  <?php
}

function check_wikiname($name) {
  global $request;
  preg_match(WIKINAME_PAT2, $name) or die("page name error");
}

function check_logined() {
  WebSession::isLogined() or die("you are not logined");
}

function set_request() {
  global $request, $method;
  $method = $_SERVER['REQUEST_METHOD'];
  if ($method == 'GET') {
    $request = $_GET;
  }
  elseif ($method == 'POST') {
    $request = $_POST;
  }
  if (get_magic_quotes_gpc()) {
    $request = array_stripslashes_recursive($request);
  }
}

function array_stripslashes_recursive($var) {
  if (is_array($var))
    return array_map('array_stripslashes_recursive', $var);
  else
    return stripslashes($var);
}

?>
