<?php

class WikiEditFormlet {
  function show() {
    global $request;
    $pageName = $request['name'];
    if (!WebSession::isEditable($pageName)) {
      WikiEditFormlet::permissionError();
    }

    $text = htmlspecialchars(Formatter::normalizeLineBreak(Storage::get($pageName)));
    $name = htmlspecialchars($pageName);
    ?>
    <form method="post" action="index.php">
      <h1>edit - <?php echo $name ?></h1>
      <input type="hidden" name="action" value="wikiedit">
      <input type="hidden" name="name" value="<?php echo $name ?>">
      <textarea name="content" cols="80" rows="25"><?php echo $text ?></textarea><br>
      edit memo: <input type="text" name="memo" size="74" value=""><br>
      ॹפ򹹿ʤ: <input type="checkbox" name="sage"><br><br>
      <input type="submit" value=" Save ">
      <input type="reset" value=" Reset ">
    </form>
    <?php
  }
  function permissionError() {
    echo "permission error";
    exit;
  }

  function action($params) {
    $pageName = $params["name"];
    if (!WebSession::isEditable($pageName)) {
      WikiEditFormlet::permissionError();
    }
    $content = $params["content"];
    $memo = $params["memo"];
	$isSage = isset($params["sage"]);
    Storage::put($pageName, $content, $memo, $isSage);
    redirect_to("index.php?mod=WikiView&name=$pageName", "񤭹ߤޤ", 0);
  }

}

class WikiViewFormlet {
  function show() {
    global $request;
    WikiViewFormlet::showPage($request["name"]);
  }
  function showPage($name) {
    $text = htmlspecialchars(Storage::get($name));
    WikiViewFormlet::showText($name, $text);
  }
  function showText($name, $text) {
    global $property;
    $name = htmlspecialchars($name);
    $formatter = new Formatter();
    $text = $formatter->formatWikiPage($text, $name);
    $muser = $property->get($name, 'last_modified_user');
    $cuser = $property->get($name, 'creator');
    $memo = $property->get($name, 'edit_memo');
    if (!$muser) $muser = 'unknown';
    if (file_exists(Storage::fileName($name)))
      $mtime = date("Y-m-d H:i:s",filemtime(Storage::fileName($name)));
    else
      $mtime = "(not yet)";
      ?>
      <h1><?php echo $name ?>
      <?php if (WebSession::isUserName($name))
        echo '<span style="font-size:small;color:brown;font-weight: normal;">(^-^) user page</span>' ?>
	</h1>
	<p><?php echo $text ?></p>
	<hr>
	<div align="right">
	<p>
	<?php if ($cuser): ?>
	  Created by <?php echo Formatter::wikiName($cuser) ?><br>
	<?php endif; ?>
	<?php if (WebSession::isEditable($name)): ?>
	  [ <a href="index.php?mod=WikiEdit&amp;name=<?php echo $name ?>">Edit this page</a> ] 
	<?php endif; ?>
	[ <a href="index.php?mod=WikiHistory&amp;name=<?php echo $name ?>">Show edit history</a> ]
	Last modified by <?php echo Formatter::wikiName($muser) ?> at <?php echo $mtime ?><br>
        <?php if ($memo): ?>
	  Edit memo: &quot;<?php echo Formatter::wikiName(htmlspecialchars($memo)) ?>&quot;
	<?php endif; ?>
	</p>
	</div>
      <?php
  }
}

class RecentChangesFormlet {
  function show() {
    foreach (Storage::recentChanges(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($time, $wikiname, $user) = $item;
      $link = Formatter::wikiName($wikiname);
      if ($user) {
	$user = "(by ".Formatter::wikiName($user).")";
      }
      if (WebSession::isUserName($wikiname)) {
	printf("%s - <span class=\"user\">%s</span> %s<br>\n", $time, $link, $user);
      }
      else {
	printf("%s - %s %s<br>\n", $time, $link, $user);
      }
    }
  }
}

class RecentCommentsFormlet {
  function show() {
    foreach (Storage::recentComments(DEFAULT_RECENT_LIST_NUMBER) as $item) {
      list($time, $wikiname, $user) = $item;
      $link = Formatter::wikiNameComment($wikiname);
      if ($user) {
	$user = "(by ".Formatter::wikiName($user).")";
      }
      if (WebSession::isUserName($wikiname)) {
	printf("%s - <span class=\"user\">%s</span> %s<br>\n", $time, $link, $user);

      }
      else {
	printf("%s - %s %s<br>\n", $time, $link, $user);
      }
    }
  }
}

class AllPagesFormlet {
  function show() {
    echo "<ol>\n";
    foreach (Storage::recentChanges(0) as $item) {
      list($time, $wikiname, $user) = $item;
      $link = Formatter::wikiName($wikiname);
      if ($user) {
	$user = "(by ".Formatter::wikiName($user).")";
      }
      if (WebSession::isUserName($wikiname)) {
	printf("<li>%s - <span class=\"user\">%s</span> %s<br>\n", $time, $link, $user);
      }
      else {
	printf("<li>%s - %s %s\n", $time, $link, $user);
      }
    }
    echo "</ol>\n";
  }
}

class WikiHistoryFormlet {
  function show() {
    global $request;
    $name = htmlspecialchars($request["name"]);
      ?>
      <h2>Edit history - <?php echo Formatter::wikiName($name) ?></h2>
      <table class="history">
        <tr><th>date/time<th>user<th>memo<th>operation</tr>
	 <?php
	 foreach (Storage::editHisoty($name) as $each) {
	   list($date, $user, $memo, $timestamp) = $each;
	   $filename = METADATA_DIR.$name."/".preg_replace("/(........)(......)/",
							   '\1-\2.txt', $timestamp);
	   if (file_exists($filename)) {
	     printf("<tr><td>%s<td>%s<td>%s<td>".
		    "<a href=\"index.php?mod=WikiVersion&amp;name=%s&amp;date=%s\">".
		    "view this version</a></tr>",
		    $date, $user, htmlspecialchars($memo), $name, $timestamp);
	   }
	 }
         ?>
      </table>
      <?php
  }
}

class WikiVersionFormlet {
  function show() {
    global $request;

    $name = strip_tags($request['name']);
    $timestamp = strip_tags($request['date']);

    WikiVersionFormlet::checkParam($name, $timestamp);

    $path = Storage::backupFilePath($name, $timestamp);
    $text = htmlspecialchars(Storage::getBackupFile($path));
    WikiVersionFormlet::showViersionPage($name, $text, $timestamp);
  }

  function checkParam($name, $timestamp) {
    preg_match(WIKINAME_PAT, $name) or die("param error");
    preg_match("/\d{14}/", $timestamp) or die("param error");
  }

  function showViersionPage($name, $text, $timestamp) {
    $date = WikiVersionFormlet::formatDate($timestamp);
    $formatter = new Formatter();
    ?>
    <h2>Content of page &quot;<?php echo Formatter::wikiName($name) ?>&quot; at <?php echo $date ?></h2>
    <?php echo $formatter->format($text) ?>
    <?php
  }

  function formatDate($timestamp) {
    return preg_replace("/^(....)(..)(..)(..)(..)(..)$/",
			'\1-\2-\3 \4:\5:\6',
			$timestamp);
  }

}

?>
