<?php

class FormletShowFormlet {
  function show() {
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
    if (!is_array($setting)) return;
    foreach (array_keys($setting) as $formlet) {
      if (isset($setting[$formlet]) &&
	  file_exists("module/".$formlet.".mod.php"))
	include "module/".$formlet.".mod.php";
    }
  }
}

class FormletEditFormlet {
  function show() {
    global $manager;
    $formlets = FormletEditFormlet::formletList();
    $account = $manager->find(WebSession::loginUserName());
    $setting = $account->getConfig("formlet");
    echo "<form>\n";
    echo "<input type=\"hidden\" name=\"action\" value=\"formletedit\">\n";
    foreach ($formlets as $formlet) {
      $value = $setting[$formlet] ? "checked=\"checked\"": "";
      echo "  <input type=\"checkbox\" name=\"formlet[$formlet]\" $value>$formlet<br>\n";
    }
    echo " <input type=\"submit\" value=\" Save \">";
    echo "</form>\n";
  }

  function action($params) {
    global $manager;
    if (!WebSession::isLogined()) {
      redirect_to("index.php", "you are not logined", 3);
    }
    $account = $manager->find(WebSession::loginUserName());
    $account->setConfig("formlet", $params["formlet"]);
    $manager->update($account);
    redirect_to("index.php?mod=UserConf", "Config saved", 0);
  }

  function formletList() {
    return array("QueueList", "WatchList", "WatchedList", "RecentList", "MyPage", "MyPageComment");
  }

}

class ThemeChooseFormlet {
  function show() {
    global $manager;
    $account = $manager->find(WebSession::loginUserName());
    if ($account) {
      $myTheme = $account->getConfig("theme");
      if (!$myTheme) $myTheme = DEFAULT_THEME;
    }
    else {
      $myTheme = DEFAULT_THEME;
    }
    echo "<form method=\"post\" action=\"index.php\">\n";
    echo "<input type=\"hidden\" name=\"action\" value=\"themechoose\">\n";
    foreach (ThemeChooseFormlet::themes() as $theme) {
      $checked = ($theme == $myTheme) ? 'checked="checked"' : '';
      printf("<input type=\"radio\" name=\"theme\" value=\"%s\" %s>%s<br>\n",
	     $theme, $checked, $theme);
    }
    echo "<input type=\"submit\" value=\" Save \">\n";
    echo "</form>\n";
  }

  function action($params) {
    global $manager;

    check_logined();
    $account = $manager->find(WebSession::loginUserName());
    if (!$account) die("invalid login name");

    foreach (ThemeChooseFormlet::themes() as $theme) {
      if (isset($params['theme'])) {
	$selected = $params['theme'];
	break;
      }
    }
    $account->setConfig("theme", $selected);
    $manager->update($account);
    redirect_to("index.php?mod=UserConf", "Config saved", 0);
  }

  function themes() {
    return array("city", "flower", "light", "marble", "mono");
  }
}

?>