<?php
class QueueListFormlet {
  function show() {
    $name = WebSession::loginUserName();
    $items = Queue::items($name);
    $logs = Queue::logs($name);
    ?>
    <form method="post" action="index.php">
      <input type="hidden" name="action" value="queue">
      <input type="hidden" name="cmd" value="add">
      <input type="text" name="item" size="80" value="">
      <input type="submit" name="top" value="  top  ">
      <input type="submit" name="bottom" value="bottom">
    </form>
    <table class="queue">
       <?php QueueListFormlet::printItems($items) ?>
    </table>
       <?php QueueListFormlet::printLogs($name, $logs) ?>
    <?php 
  }

  function printItems($items) {
    $i = 0;
    foreach ($items as $item) {
      $formatter = new Formatter();
      $mes = $formatter->format(rtrim(htmlspecialchars($item)));
      $td = '<td>';
      $line = QueueListFormlet::tr($i).
        $td.QueueListFormlet::sage($i).
        $td.$mes.
        $td.QueueListFormlet::age($i).
        $td.QueueListFormlet::ok($i).
        $td.QueueListFormlet::del($i);
      echo $line, "\n";
      $i++;
    }
  }

  function url($pos, $cmd, $symbol) {
    return sprintf('<a href="index.php?action=queue&amp;&amp;cmd=%s&amp;pos=%d" class="button">'.
                   '%s</a>',
                   $cmd, $pos, $symbol);
  }
  function sage($pos) {
    return QueueListFormlet::url($pos, "sage", "v");
  }
  function age($pos) {
    return QueueListFormlet::url($pos, "age", "^");
  }
  function ok($pos) {
    return QueueListFormlet::url($pos, "ok", "OK");
  }
  function del($pos) {
    return QueueListFormlet::url($pos, "del", "DEL");
  }

  function tr($i) {
    if ($i % 2) return '<tr class="even">';
    else return '<tr class="odd">';
  }

  function printLogs($name, $logs) {
    if (!$logs) return;
    rsort($logs);
    $last = "";
    echo "<dl>";
    foreach ($logs as $log) {
      list($year, $month, $day, $hour, $min, $sec, $mes) = explode("\t", $log);
      $date = sprintf("%04d-%02d-%02d", $year, $month, $day);
      if ($date != $last)
	printf("<dt>%s</dt>", $date);
      $mes = rtrim(htmlspecialchars($mes));
      $formatter = new Formatter();
      $mes = $formatter->format($mes);
      printf("<dd>%02d:%02d:%02d&nbsp;%s", $hour, $mis, $sec, $mes);
      $last = $date;
    }
    echo "</dl>";
  }

  function action($params) {
    WebSession::isLogined()  or die("user name unmatch");
    $name = WebSession::loginUserName();
    $cmd = $params['cmd'];
    $pos = $params['pos'];
    switch ($cmd) {
    case 'add':
      Queue::add($params);
      break;
    case 'age':
      Queue::age($name, $pos);
      break;
    case 'sage':
      Queue::sage($name, $pos);
      break;
    case 'ok':
      Queue::ok($name, $pos);
      break;
    case 'del':
      Queue::del($name, $pos);
      break;
    }  
  }
}

class QueueLogEditFormlet {
  function show() {
    $name = WebSession::loginUserName();
    $logs = Queue::logs($name);
    $last = "";
    $count = 0;
    ?>
    <h2>Queue log edit</h2>
    <form action="index.php" method="get">
      <input type="hidden" name="action" value="queuelogedit">
      <dl>
    <?php
    foreach ($logs as $log) {
      list($year, $month, $day, $hour, $min, $sec, $mes) = explode("\t", $log);
      $date = sprintf("%04d-%02d-%02d", $year, $month, $day);
      if ($date != $last)
	printf("<dt>%s</dt>", $date);
      $mes = htmlspecialchars($mes);
      printf('<dd><input name="d[%d]" type="checkbox">'.
	     "%02d:%02d:%02d&nbsp;%s", $counter, $hour, $mis, $sec, $mes);
      $last = $date;
      $counter++;
    }
    echo "</dl>";
    ?>
      </dl>
      <input type="submit" value=" Delete ">
    </form>
    <?php
  }

  function action($params) {
    if (!is_array($params["d"])) {
      redirect_to("index.php?mod=QueueLogEdit", "򤵤Ƥޤ", 1);
      exit;
    }
    $name = WebSession::loginUserName();
    $dels = array_keys($params["d"]);
    Queue::removeFromLog($name, $dels);
    redirect_to("index.php", "ޤ", 0);
  }


}
