<?php

class CommentFormlet {

  function show($num=DEFAULT_COMMENT_NUMBER) {
    global $request;
    $page = $request['name'];
    CommentFormlet::showPage($page, $num);
  }

  function showPage($page, $num) {
    $comments = CommentFormlet::getComments($page);
    $i = 0;
    // if $num == 0, show all comments
    if (count($comments) > DEFAULT_COMMENT_NUMBER && $num != 0) {
      $i = count($comments) - $num;
      $comments = array_slice($comments, 0 - $num);
    }
    foreach ($comments as $c) {
      $i++;
      CommentFormlet::printComment($c, $i);
    }
    $user = WebSession::loginUserName();
    ?>
      <a name="comment"><form method="post" action="index.php"></a>
      <input type="hidden" name="action" value="comment">
      <input type="hidden" name="name" value="<?php echo $page ?>">
      <textarea name="content" cols="60" rows="3"></textarea><br>
      <input type="submit" value=" Post ">
      <?php if(!WebSession::isLogined()): ?>
       User̾=Guest Ƥޤ
      <?php endif; ?>
      </form>
    <?php
  }

  function getComments($page) {
    $result = array();
    $path = DATA_DIR.$page.".cmt";
    if (!file_exists($path)) return $result;
    $tmp = file($path);
    foreach ($tmp as $i) {
      $result[] = unserialize($i);
    }
    return $result;
  }

  function printComment($comment, $num) {
    $comment->unescape();
    $text = rtrim($comment->content);
    $text = htmlspecialchars($text);
    $formatter = new Formatter();
    $text = $formatter->format($text);
      ?>
      <dl><dt>
	 <?php echo $num ?>
	 ̾<?php echo Formatter::wikiName($comment->name) ?>
	 (<?php echo $comment->date ?>)</dt>
	 <dd><?php echo $text ?></dd></dl>
	 <?php
	 }

  function action($params) {
    global $property;
    $pageName = $params['name'];
    $userName = WebSession::loginUserName();
    $content = $params["content"];

    $date = date("Y-m-d H:i:s");
    $comment = new Comment($date, $userName, $content);
    CommentFormlet::appendComment($comment, $pageName);
    $property->set($pageName, 'last_commented_user', WebSession::loginUserName());
    Rss::writeRecentComments();
    redirect_to("index.php?mod=WikiView&name=$pageName#comment",
		"ȤƤޤ", 0);
  }

  function appendComment($comment, $page) {
    $path = DATA_DIR.$page.".cmt";
    $fp = fopen($path, "a") or die("comment file open error");
    $comment->escape();
    fwrite($fp, serialize($comment)."\n");
    fflush($fp);
    fclose($fp);
  }
}


class Comment {
  var $date, $name, $content;
  function Comment($date, $name, $content) {
    $this->date = $date;
    $this->name = $name;
    $this->content = $content;
  }
  function escape() {
    $this->content = $this->escapeLineBreak($this->content);
  }
  function unescape() {
    $this->content = $this->unescapeLineBreak($this->content);
  }
  function escapeLineBreak($str) {
    $match = array("/\r/", "/\r\n/", "/\n/");
    $replace = array("", "\n", chr(255));
    return preg_replace($match, $replace, $str);
  }
  function unescapeLineBreak($str) {
    $match = array("/".chr(255)."/");
    $replace = array("\n");
    return preg_replace($match, $replace, $str);
  }
}

?>
