#include <stdio.h>

static char version[] = "0.15.5 beta";

/* 関数プロトタイプ */
void help(void);

/*******************************************************************************
 * ヘルプ
*******************************************************************************/
void help()
{
	printf("バージョン %s\n", version);
	puts("使用方法 : snowcp [option] src dst");
	puts("srcからdstへコピーする。optionとsrcは複数可。dstが存在しない場合は自動的に作成する。");
	puts("");
	puts("オプション");
	puts(" -b NUMBER  バッファの量を指定する（MB単位、デフォルト値は32）。");
	puts("            (例 : snowcp -b 64 src dst)");
	puts("");
	puts(" -h         ヘルプを表示する。");
	puts("            (例 : snowcp -h)");
	puts("");
	puts(" -i         ファイルを上書きする前に確認する。");
	puts("            (例 : snowcp -i src dst)");
	puts("");
	puts(" -I         -iオプションを無効にする。");
	puts("            (例 : snowcp -I src dst)");
	puts("");
	puts(" -l         ベリファイのログを保存する。");
	puts("            (例 : snowcp -r 2 -l src dst)");
	puts("");
	puts(" -L         -lオプションを無効にする。");
	puts("            (例 : snowcp -L src dst)");
	puts("");
	puts(" -m         コピー終了後、コピー元を削除する。");
	puts("            (例 : snowcp -m src dst)");
	puts("");
	puts(" -M         -mオプションを無効にする。");
	puts("            (例 : snowcp -M src dst)");
	puts("");
	puts(" -o         設定を保存する。");
	puts("            (例 : snowcp -o)");
	puts("");
	puts(" -r MODE    ベリファイ(MD5)を行う。");
	puts("            MODEが1の場合はコピー直後に、");
	puts("            2の場合は全コピー終了後にベリファイを実行する。");
	puts("            一致しなかった場合はdstを削除する。");
	puts("            0の場合はこのオプションを無効にする。");
	puts("            (例 : snowcp -r 1 src dst)");
	puts("");
	puts(" -t MODE    スレッドモードを指定する。");
	puts("            MODEが1の場合は常に同一ドライブモード、");
	puts("            2の場合は常に別ドライブモード、");
	puts("            0の場合は自動判別モードで動作する。");
	puts("            (例 : snowcp -t 1 src dst)");
	puts("");
	puts(" -v         コピー中のファイル名を表示する。");
	puts("            (例 : snowcp -v src dst)");
	puts("");
	puts(" -w MODE    上書きモードを指定する。");
	puts("            MODEが1の場合はサイズか日付が異なる時、");
	puts("            2の場合は日付が新しい時、");
	puts("            3の場合は常に上書きする。");
	puts("            0の場合、上書きしない。");
	puts("            (例 : snowcp -w 3 src dst)");
	puts("");
	puts("オプションを付けずに実行した場合、以下と同じ動作をする。");
	puts("snowcp -b 32 -t 0 -w 1 src dst");
	puts("");
	puts("設定ファイルよりもオプションの方が優先順位は上である。例えば設定ファイルで -r 2 オプションが有効でも、実行時に snowcp -r 0 src dst とすれば -r オプションは無効になる。");
	puts("");
	puts("オプションは後に入力した方が優先される。例えば snowcp -iw とした場合は -w オプションが有効になる。");
	puts("");
	puts("-i オプションを付けた場合、ファイルサイズやタイムスタンプの比較は行われない。");
	puts("");
	puts("スレッドモードは引数として与えたファイル／フォルダを基準とするため、サブフォルダにファイルシステムをマウントしている場合は、正常に動作しない。");
	puts("");
}
