#include "append_list.h"
#include "struct_DPath.h"
#include "xmalloc.h"

#include <string.h>

#include <linux/limits.h>

/* 関数プロトタイプ */
VList * get_drive_list(void);

/*******************************************************************************
 * /etc/mtabを参照してドライブのリストを作成する。
 * 
 * ファイルシステムのチェックをしないなら、
 * いちいちmtab開かなくてもst_devを参照することで同一HDDかどうか調べられるっぽい？
 * ↑試してみたけど、同一HDDでも別ファイルシステムの場合、st_devの値も変わるので×。
 * あとst_devの型はdev_tだが__dev_tのtypedefで、元はlong long intっぽい。
*******************************************************************************/
VList * get_drive_list(void)
{
	DPath *d_path = NULL;
	VList *drive_list = NULL;
	FILE *mtab;

	if((mtab = fopen("/etc/mtab", "r")) == NULL)
	{
		fprintf(stderr, "mtabのオープンに失敗しました\n");
		exit(EXIT_FAILURE);
	}
	else
	{
		/* mtabの一行の最大長をPATH_MAXの3倍と仮定 */
		int mtab_line = PATH_MAX * 3;
		char mtab_buf[mtab_line];

		while(fgets(mtab_buf, mtab_line, mtab) != NULL)
		{
			if(strncmp("/dev/sd", mtab_buf, 7) == 0)
			{
				char *tmp = strtok(mtab_buf, " ");
				int len = strlen(tmp);
				int lenp1 = (len + 1);

				/* デバイス名を短くする。　例：/dev/sda1　→　/dev/sda */
				for(int i = len - 1; i > 0; i--)
				{
					char c = tmp[i];

					/* 文字コードがASCII互換じゃないと駄目かもしれない。 */
					if((c >= '0') && (c <= '9'))
					{
						tmp[i] = '\0';
					}
					else
					{
						break;
					}
				}

				d_path = xmalloc(sizeof(DPath));
				/* ここ、lenp1でmallocすると、1バイトか2バイトほど無駄遣い。 */
				d_path->device = xmalloc(lenp1);
				memcpy(d_path->device, tmp, lenp1);

				tmp = strtok(NULL, " ");
				d_path->mount_point = xmalloc(strlen(tmp) + 1);
				strcpy(d_path->mount_point, tmp);

				tmp = strtok(NULL, " ");
				d_path->fs = xmalloc(strlen(tmp) + 1);
				strcpy(d_path->fs, tmp);

				drive_list = append_list((void *)d_path, drive_list);
			}
		}
		fclose(mtab);
	}

	return drive_list;
}
