#ifndef APPEND_LIST_H
#define APPEND_LIST_H

#include "struct_VList.h"
#include "xmalloc.h" // inline

static VList *now;
static VList *before_last;

/* 関数プロトタイプ */
static inline VList * append_list(const void *tmp, VList *first);

/*******************************************************************************
 * 連結リストに構造体を追加し、リストを繋ぐ
*******************************************************************************/
static inline VList * append_list(const void *tmp, VList *first)
{
	if(first == NULL)
	{
		/* リストに最初の要素を追加する */

		first = xmalloc(sizeof(VList));
		/*
		* キャストしないと警告が出る
		* warning: initialization discards qualifiers from pointer target type
		*/
		first->data = (void *)tmp;
		first->next = NULL;
		first->prev = NULL;
		first->tail = first;
	}
	else
	{
		now = xmalloc(sizeof(VList));
		before_last = first->tail;
		/*
		* キャストしないと警告が出る
		* warning: initialization discards qualifiers from pointer target type
		*/
		now->data = (void *)tmp;
		now->next = NULL;
		now->tail = NULL;

		now->prev = before_last;
		before_last->next = now;

		first->tail = now;
	}

	return first;
}

#endif
