#ifndef DO_COMPARE_VERIFY_ONE_H
#define DO_COMPARE_VERIFY_ONE_H

#include "print_error.h"	// inline
#include "source_unlink.h"
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "struct_SDir.h"
#include "verify_hash.h"

#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>

#include <errno.h>
#include <unistd.h> 

static inline void do_compare_verify_two(const OPArg *oparg, const VList *file_list, const SDir *sdir, CPDD *cpdd) __attribute__((always_inline));

/*******************************************************************************
*******************************************************************************/
static inline void do_compare_verify_two(const OPArg *oparg, const VList *file_list, const SDir *sdir, CPDD *cpdd)
{
	/*
	 * キャストしないと警告が出る
	 * warning: initialization discards qualifiers from pointer target type
	 */
	VList *tmp = (VList *)file_list;

	for(;;)
	{
		CPInfo *cpinfo = (CPInfo *)tmp->data;

		if(cpinfo->src_type == REGULAR)
		{
			switch(oparg->CHECK)
			{
			case V_FIVE:
				if((cpinfo->src_md5 != NULL) && (cpinfo->dst_size > 0) && (cpinfo->d_para == WRITE))
				{
					verify_hash(oparg, sdir, cpinfo, cpdd);

					if((oparg->M == MOVE) && (cpinfo->hash_check == true))
					{
						SOURCE_UNLINK
					}
				}
				break;

			default:
				fprintf(stderr, "ハッシュチェックオプションが不正です");
				break;
			}
		}

		if(tmp->next == NULL)
		{
			break;
		}

		tmp = tmp->next;
	}
}

#endif
