#ifndef DO_COMPARE_VERIFY_ONE_H
#define DO_COMPARE_VERIFY_ONE_H

#include "source_unlink.h"
#include "struct_CPDD.h"
#include "struct_CPInfo.h"
#include "struct_OPArg.h"
#include "struct_SDir.h"
#include "verify_hash.h"

static inline void do_compare_verify_one(const OPArg *, const SDir *, CPInfo *, CPDD *) __attribute__((always_inline));

/******************************************************************************
*******************************************************************************/
static inline void do_compare_verify_one(const OPArg *oparg, const SDir *sdir, CPInfo *cpinfo, CPDD *cpdd)
{
	if(oparg->CHECK_MODE == BEFORE)
	{
		switch(oparg->CHECK)
		{
		case V_FIVE:
			if((cpinfo->src_md5 != NULL) && (cpinfo->dst_size > 0) && (cpinfo->d_para == WRITE))
			{
				verify_hash(oparg, sdir, cpinfo, cpdd);

				if((oparg->M == MOVE) && (cpinfo->hash_check == true))
				{
					SOURCE_UNLINK
				}
			}
			break;

		default:
			fprintf(stderr, "ハッシュチェックオプションが不正です\n");
			break;
		}
	}
}

#endif
