#ifndef STRUCT_COPY_INFOMATION_H
#define STRUCT_COPY_INFOMATION_H

#include <sys/types.h>

typedef enum copy_file_type
{
	REGULAR,
	SYMBOLICLINK,
	DIRECTORY,
} CFT;

typedef enum copy_mode_flag
{
	SAME,
	DIFFERENT,
} CMF;

typedef enum dst_parameter
{
	WRITE,
	SKIP,
	DELETE,

	INITIAL,
} DPT;

typedef enum src_parameter
{
	/* 同じ名前は使えないのでDELETEではなくUNLINKにした */
	UNLINK,

	/* 同じ名前は使えないのでINITIALではなくDEFAULTにした */
	DEFAULT,
} SPT;

typedef struct copy_infomation
{
	char *src;
	char *dst;
	char *dstfs;
	CFT src_type;
	CMF copy_mode;
	DPT d_para;
	SPT s_para;
	_Bool hash_check;
	_Bool file_test;
	char *src_md5;
	off_t src_size;
	off_t dst_size;
} CPInfo;

#endif
