#ifndef STRUCT_OPTION_FLAG_H
#define STRUCT_OPTION_FLAG_H

#include "struct_VList.h"

#include <sys/types.h>

typedef enum option_flag
{
	ONE, /* コンペア（SHA-1） */
	FIVE, /* コンペア（MD5） */
	MEMCMP, /* コンペア（memcmp） */
	V_FIVE, /* ベリファイ（MD5） */
	BEFORE,
	AFTER,
	LOG, /* コンペアログ保存 */

	SIZE_OR_TIME,
	NEW_TIME,
	OVERWRITE,
	NO_OVERWRITE, /* -0 */

	DRIVE_AUTO,
	DRIVE_SAME,
	DRIVE_DIFFERENT,

	INTERACTIVE, /* 上書き確認 */
	MOVE, /* 移動モード */
	VERBOS, /* コピー中ファイル名表示 */

	NOT, /* オプション無効 */
	EXIST, /* オプション有り */
} OPFlag;

typedef struct option_and_argument
{
	/* MD5ライブラリの引数がintなので、バッファサイズもintが上限 */
	int buffer_size;
	VList *b_size_list;

	enum option_flag CHECK;
	enum option_flag CHECK_MODE; /* 1 or 2 */
	enum option_flag WRITE_MODE; /* 1 or 2 or 3 or 0*/
	enum option_flag THREAD_MODE; /* 1 or 2 or 0 */
	enum option_flag I;
	enum option_flag L;
	enum option_flag M;
	enum option_flag V;
	enum option_flag EFFECT;
	int argc; /* 引数の数。main()の仮引数を入れる。 */
	int fromindex; /* getoptのoptindを入れる */
	int toindex; /* argv[argc - 1] */
	int arg_count; /* コピー元の数 */
	char **argv; /* main()の仮引数を入れる。 */
} OPArg;

#endif
