#ifndef INCLUDED_STRUCT_OPTARG_H
#define INCLUDED_STRUCT_OPTARG_H

typedef enum option_flag
{
	BUFFER, /* バッファサイズ指定 */
	COMPARE, /* コンペア（memcmp） */
	DIRECT_IO, /* ダイレクトI/Oモード */
	FIVE, /* コンペア（MD5） */
	INTERACTIVE, /* 上書き確認 */
	LOG, /* コンペアログ保存 */
	MOVE, /* 移動モード */
	NO_OVERWRITE, /* 非上書き */
	ONE, /* コンペア（SHA-1） */
	VERBOS, /* コピー中ファイル名表示 */
	WRITE_MODE, /* 上書きモード */

	NOT, /* オプション無効 */
	EXIST, /* オプション有り */
} OPFlag;

#include <sys/types.h>

typedef struct option_and_argument
{
	int argc; /* 引数の数。main()の仮引数を入れる。 */
	int fromindex; /* getoptのoptindを入れる */
	int toindex; /* argv[argc - 1] */
	int arg_count; /* コピー元の数 */
	char **argv; /* main()の仮引数を入れる。 */
	enum option_flag B;
	enum option_flag C;
	enum option_flag D;
	enum option_flag I;
	enum option_flag L;
	enum option_flag M;
	enum option_flag N;
	enum option_flag V;
	enum option_flag W;
	enum option_flag EFFECT;
	int compare_mode; /* 1 or 2 */
	int write_mode; /* 1 or 2 or 3 */
	off_t buffer_size;
} OPArg;

#endif
