#define _GNU_SOURCE

#include "global.h"
#include "struct.h"

#include "list_append.h"
#include "snowcp.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <glib.h>

static int error_count = 0;

// 関数プロトタイプ
void log_errors(const char *file, const int line, const int error_num, const char *target);
void log_errors_count(void);
void log_compare(char *from, char *f_hash, char *to, char *t_hash, _Bool b);
static void get_time_now(char *hms);

/*******************************************************************************
エラーを表示
*******************************************************************************/
void log_errors(const char *file, const int line, const int error_num, const char *target)
{
	fprintf(stderr, "error %d, %s %d行目\n", error_num, file, line);
	fprintf(stderr, "tartet : %s\n", target);

	error_count++;
}

/*******************************************************************************
エラー数を表示
*******************************************************************************/
void log_errors_count()
{
	if(error_count > 0)
	{
		printf("総エラー数 %d\n", error_count);
	}
}

/*******************************************************************************
コンペアの結果を保存
*******************************************************************************/
void log_compare(char *from, char *f_hash, char *to, char *t_hash, _Bool b)
{
	// ログを保存するフォルダが存在しない場合は作成する
	if(g_file_test(config_dir, G_FILE_TEST_EXISTS) == FALSE)
		mkdir(config_dir, 0777);
	if(g_file_test(settings_dir, G_FILE_TEST_EXISTS) == FALSE)
		mkdir(settings_dir, 0777);
	if(g_file_test(log_dir, G_FILE_TEST_EXISTS) == FALSE)
		mkdir(log_dir, 0777);

	char *target_dir;
	if(b == true)
	{
		if(g_file_test(compare_success_dir, G_FILE_TEST_EXISTS) == FALSE)
			mkdir(compare_success_dir, 0777);
		target_dir = compare_success_dir;
	}
	else
	{
		if(g_file_test(compare_error_dir, G_FILE_TEST_EXISTS) == FALSE)
			mkdir(compare_error_dir, 0777);
		target_dir = compare_error_dir;
	}

	// ログを保存するフォルダに移動してログを書き込む
	if(chdir(target_dir) == 0)
	{
		FILE *log = fopen(today, "a");
		char hms[9];
		get_time_now(hms);
		fputs(hms, log);
		fputs("\n", log);
		fputs(f_hash, log);
		fputs(",", log);
		fputs(from, log);
		fputs("\n", log);
		fputs(t_hash, log);
		fputs(",", log);
		fputs(to, log);
		fputs("\n", log);
		fclose(log);
		chmod(today, 0777);
		fchdir(current_fd);
	}
	else
	{
		fprintf(stderr, "ログを保存出来ませんでした\nログフォルダに移動できません\n");
	}
}

/*******************************************************************************
現在時刻を取得
*******************************************************************************/
void get_time_now(char *hms)
{
	time_t timer;
	struct tm *t_st;
	time(&timer);
	t_st = localtime(&timer);
	sprintf(hms, "%d%s%d%s%d", t_st->tm_hour, ":", t_st->tm_min, ":", t_st->tm_sec);
}
