/* $Id: ShowLinesActionListener.java 300 2011-08-12 02:54:22Z ohura $ */
package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;

public class ShowLinesActionListener implements ActionListener {

	private AbstractGSWindow parent;

	public ShowLinesActionListener(AbstractGSWindow parent) {
		this.parent = parent;
	}

	public void actionPerformed(ActionEvent e) {
		ImageLabel.Show mode = this.parent.getSpreadCanvas().imageLabel.getLineSegmentShowingMode();
		this.parent.getSpreadCanvas().imageLabel.stepLineSegmentShowingMode(mode);
		if(parent instanceof WorkspaceWindow) {
			WorkspaceWindow.getInstance().repaint();
		} else if (parent instanceof GSEditor) {
			parent.repaint();
		}
	}

}
