/* $Id: GSTreeTextEditortPaneMamager.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.smleditor.swingui;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

import smart_gs.logical.SmartDocument;
import smart_gs.swingui.GSTabbedPaneMamagerContainer;


public class GSTreeTextEditortPaneMamager {
	protected static HashMap<String, GSTreeTextEditortPaneMamagerContainer> gsTreeTextEditorMap = new HashMap<String,  GSTreeTextEditortPaneMamagerContainer>();
	protected static HashMap<String, String> windowMap = new HashMap<String,  String>();
	protected static AtomicLong id = new AtomicLong();

	public static void setGSTreeTextEditort(String key,String windowid,GSTreeTextEditor gsTreeTextEditor){
		synchronized (gsTreeTextEditorMap) {
			GSTreeTextEditortPaneMamagerContainer gsTreeTextEditortPaneMamagerContainer = new GSTreeTextEditortPaneMamagerContainer(key,windowid,gsTreeTextEditor);
			gsTreeTextEditorMap.put(key, gsTreeTextEditortPaneMamagerContainer);
			if(!windowMap.containsKey(windowid)){
				windowMap.put(windowid,key);
			}

		}
	}
	public static void removeGSTreeTextEditort(String key){
		synchronized (gsTreeTextEditorMap) {
			gsTreeTextEditorMap.remove(key);
		}
	}
	public static GSTreeTextEditor getGSTreeTextEditort(String key){
		GSTreeTextEditortPaneMamagerContainer gsTreeTextEditortPaneMamagerContainer = gsTreeTextEditorMap.get(key);
		if(gsTreeTextEditortPaneMamagerContainer == null){
			return null;
		}
		return gsTreeTextEditortPaneMamagerContainer.getGsTreeTextEditor();
	}
	
	public static String getWindowsID(String key){
		GSTreeTextEditortPaneMamagerContainer gsTreeTextEditortPaneMamagerContainer = gsTreeTextEditorMap.get(key);
		if(gsTreeTextEditortPaneMamagerContainer == null){
			return null;
		}
		return gsTreeTextEditortPaneMamagerContainer.getWindowid();
	}

	public static long getControlid(){
		return id.incrementAndGet();
	}

	public static void close(String windowid){
		synchronized (gsTreeTextEditorMap) {
			String key = windowMap.get(windowid);
			windowMap.remove(windowid);
			// JĂWindow݂Ȃ
			if(!windowMap.containsValue(key)){
				synchronized (gsTreeTextEditorMap) {
					gsTreeTextEditorMap.remove(key);
				}
			}
		}
	}

}
