/* $Id: GSTreeTextEditor.java 223 2011-06-13 14:31:03Z shayashi $ */
package smart_gs.smleditor.swingui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.current_text_search.SearchDialogManager;
import smart_gs.logical.SmartDocument;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorFrame;

import com.hexidec.ekit.GSHTMLEditorFoucsActionListner;
import com.hexidec.ekit.GSHTMLEditorSearchActionListner;

@SuppressWarnings("serial")
public class GSTreeTextEditor extends JFrame implements EditorFrame{
	
	private SmartDocument document;
	
//	private GSTabbedPane tabbedPane;
	private JToolBar toolBar;
	private GSEditorTextPane textPane;
	protected GSEditorToolBar gsEditorToolBar;
	protected int open = 0;
	protected long id;
	
	public GSTreeTextEditor(SmartDocument document, String name){
		super(name);

		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		this.document = document;
		String xml = this.document.getSource();
		String source = null;
		if(xml.startsWith("<xml><html>") && xml.endsWith("</html></xml>")){
			source = xml.substring("<xml><html>".length(),xml.length() - "</html><xml>".length());
		}
		this.textPane = new GSEditorTextPane(this.document,source);
		textPane.getGSHTMLEditorTextPane().setMouseListener(new GSWysiwygMouseListener(textPane));
		textPane.getGSHTMLEditorTextPane().setDocumentListener(new GSWysiwygDocumentListener(textPane));
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
//		this.tabbedPane = new GSTabbedPane(document,this);
		
		JPanel toolBarPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		
	//	GSEditorTextPane textPane = this.tabbedPane.getTextPane();
		gsEditorToolBar = new GSEditorToolBar(textPane);
		this.toolBar = gsEditorToolBar;
		toolBarPanel.add(this.toolBar);

		textPane.setSearchAction(new SearchAction(gsEditorToolBar));
		textPane.setFocusAction(new FoucsAction(this,gsEditorToolBar));
		SearchDialogManager.setGSEditorToolBar(gsEditorToolBar);
		
		this.getContentPane().add(toolBarPanel,BorderLayout.NORTH);
		this.getContentPane().add(this.textPane,BorderLayout.CENTER);

		//2008/9/19 North Grid
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				ok();
			}
		});
		id = GSTreeTextEditortPaneMamager.getControlid();
		this.addWindowListener(new GSTreeTextWindowAdapter(String.valueOf(document.getId()),String.valueOf(document.getId()) + String.valueOf(id),this));
		this.setSize(800,600);
		this.validate();
	}
	
	public void ok() {
		String source = textPane.getSource("body");
		this.document.setSource("<xml><html>" + source + "</html></xml>");
		this.dispose();
	}

	public void setEditorToolBar(JToolBar toolbar) {
		
	}
	
	public GSEditorToolBar getGSEditorToolBar(){
		return gsEditorToolBar;
	}
	
	public int getDocumentID(){
		return this.document.getId();
	}
	//20071215 shimizu wrote
	public void emphasize(String id) {
		// 20080919 hashimoto wrote
		this.textPane.emphasize(id);
//		this.textPane.getGSHTMLEditorTextPane().emphasize(id);
	}
	//20080901 hashimoto wrote
	public GSEditorTextPane getGSEditorTextPane() {
		return this.textPane;
	}
	
	private class SearchAction implements GSHTMLEditorSearchActionListner{
		protected GSEditorToolBar gsEditorToolBar;
		public SearchAction(GSEditorToolBar gsEditorToolBar) {
			this.gsEditorToolBar = gsEditorToolBar;
		}
		public void actionPerformed() {
			SearchDialogManager.setGSEditorToolBar(gsEditorToolBar);
			SearchDialogManager.visible();
		}
	}

	private class FoucsAction implements GSHTMLEditorFoucsActionListner{
		protected GSEditorToolBar gsEditorToolBar;
		protected GSTreeTextEditor gsTreeTextEditor;
		public FoucsAction(GSTreeTextEditor gsTreeTextEditor,GSEditorToolBar gsEditorToolBar) {
			this.gsEditorToolBar = gsEditorToolBar;
			this.gsTreeTextEditor = gsTreeTextEditor;
		}
		public void focusGained() {
			SearchAllDialogManager.setEditor(gsTreeTextEditor, gsEditorToolBar);
			SearchDialogManager.setGSEditorToolBar(gsEditorToolBar);
		}
		public void focusLost() {
			
		}
	}

	class GSTreeTextWindowAdapter extends WindowAdapter{
		protected GSTreeTextEditor gsTreeTextEditorSrc;
		protected String key;
		protected String windowid;
		public GSTreeTextWindowAdapter(String key,String windowid,GSTreeTextEditor gsTreeTextEditor){
			this.key = key;
			this.windowid = windowid;
			this.gsTreeTextEditorSrc = gsTreeTextEditor;
		}
        public void windowClosing(WindowEvent e) {
        }
        public void windowActivated(WindowEvent e) {
        	GSTreeTextEditor gsTreeTextEditor = GSTreeTextEditortPaneMamager.getGSTreeTextEditort(key);
        	if(gsTreeTextEditor != null){
        		String oldwindowid = GSTreeTextEditortPaneMamager.getWindowsID(key);
        		if(oldwindowid == null){
        			return;
        		}
        		if(oldwindowid.equals(windowid)){
        			return;
        		}
        		GSEditorTextPane textPane = gsTreeTextEditor.getGSEditorTextPane();
        		if(textPane != null){
        			gsTreeTextEditorSrc.getGSEditorTextPane().setSource(textPane.getSource());
        			gsTreeTextEditorSrc.getGSEditorTextPane().save();
		        	GSTreeTextEditortPaneMamager.removeGSTreeTextEditort(key);
        		} 
        	}
        	open = 1;

        }
        public void windowDeactivated(WindowEvent e) {
        	gsTreeTextEditorSrc.getGSEditorTextPane().save();
        	GSTreeTextEditortPaneMamager.setGSTreeTextEditort(key,windowid,gsTreeTextEditorSrc);
        }
        public void windowClosed(WindowEvent e) {
        	GSTreeTextEditortPaneMamager.close(windowid);
        	open = 2;
        }
	}
	
	public int isOpened(){
		return open;
	}
}
