/* $Id: LocalViewFrame.java 320 2011-08-25 14:13:37Z shayashi $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import reasoning_web.logical.Connection;
import smart_gs.logical.SmartDocument;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.ButtonFrame;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.Quadruple;
import smart_gs.util.Triple;



@SuppressWarnings("serial")
//2007/11/2 kazuhiro kobayashi
public class LocalViewFrame extends ButtonFrame{
	
	private ArrayList<Quadruple<Connection,GS_RWElement,GSExplanatoryNote,Integer>> elements;
	private JPanel localViewPanel;
	
	//
	private ArrayList<GSEditorTextPane> textPanes = new ArrayList<GSEditorTextPane>();
	private ArrayList<SmartDocument> documents = new ArrayList<SmartDocument>();
	private ArrayList<JTextField>  nameFields = new ArrayList<JTextField>();
	private ArrayList<Connection> connections = new ArrayList<Connection>();
	
	public static final int HEIGHT = 200;
	public static final int WIDTH = HEIGHT*2;	
	public LocalViewFrame(ArrayList<Quadruple<Connection, GS_RWElement, GSExplanatoryNote, Integer>> info){
		super("","Local View");
		this.elements = info;
		this.localViewPanel = new LocalViewPanel(this.elements, this);
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.getVerticalScrollBar().setUnitIncrement(25);
		scrollPane.setViewportView(this.localViewPanel);
		this.getContentPane().add(scrollPane,BorderLayout.CENTER);
    	PointerInfo pointerInfo = MouseInfo.getPointerInfo();
    	Point p = pointerInfo.getLocation();
    	this.setLocation(p.x-WIDTH/2+25,p.y-HEIGHT+33);
	
		this.validate();
		this.pack();
		this.setVisible(true);
	}
	
	//2007/11/12 kazuhiro kobayashi
	public void ok(){
		this.notifyCurrentStateOfTextPane();
		this.dispose();
		WorkspaceWindow.getInstance().updateGUI();
	}
	public void cancel(){
		this.dispose();
	}
//	This is called from LocalViewPanel, when each row for connections is built.
	public void addTextPane(GSEditorTextPane textPane,JTextField nameField,Connection connection){
		this.textPanes.add(textPane);
		this.documents.add(textPane.getSmartDocument());
		this.nameFields.add(nameField);
		this.connections.add(connection);
	}
	public void notifyCurrentStateOfTextPane(){
		for(int i = 0; i < this.textPanes.size(); i++){
			Connection connection = connections.get(i);
			GSEditorTextPane textPane = this.textPanes.get(i);
			String name = this.nameFields.get(i).getText();		
			connection.setName(name);
			SmartDocument document = this.documents.get(i);
			document.setSource("<xml><html>" + textPane.getSource("body") + "</html></xml>");
		}
	}
}
