/* $Id: DesktopElementView.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.desktop.swingui.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class DesktopElementView{
	
	private JLabel iconLabel;
	private ImageIcon icon;
	
	public DesktopElementView(){
		this.icon = this.getImageIcon();
		this.iconLabel = new JLabel("default",this.icon,JLabel.CENTER);
		this.iconLabel.setHorizontalTextPosition(JLabel.CENTER);
		this.iconLabel.setVerticalTextPosition(JLabel.BOTTOM);
		this.iconLabel.setBounds(300,100,80,80);
	}

	public JLabel getLabel(){
		return this.iconLabel;
	}
	public void setName(String name){
		this.iconLabel.setText(name);
	}
	public void moveBy(Point p){
		Rectangle rect = this.iconLabel.getBounds();
		this.iconLabel.setBounds(rect.x+p.x,rect.y+p.y,rect.width,rect.height);
	}
	public abstract boolean isFolder();
	
	public boolean contains(Point p){
		Rectangle rect = this.iconLabel.getBounds();
		Rectangle2D rect2D = new Rectangle2D.Double(rect.x,rect.y,rect.width,rect.height);
		if(rect2D.contains(p)){
			return true;
		}
		return false;
	}
	protected abstract ImageIcon getImageIcon();
}
