/* $Id: ShortCut.java 391 2011-10-10 15:17:20Z minao $ */
package smart_gs.reasoning_web.desktop.logical;

import javax.swing.JLabel;
import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.GSVersion;
import smart_gs.debugprint.Debugprint;
import smart_gs.logical.GSResource;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.URICreator;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.swingui.ReasoningWebDesktop;
import smart_gs.reasoning_web.desktop.swingui.view.DesktopElementView;
import smart_gs.reasoning_web.desktop.swingui.view.ShortCutView;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;

public class ShortCut extends DesktopElement implements URIBearer {
	
	private GS_RWElement resource;
	private String uri;
	private String originalURI;
	private String oldVersionURI;
	private String version;
	private String resourceURI;
	
	public ShortCut(){
		super();
		this.setURIs();
		this.setVersion(GSVersion.getVersion());
	}
	
	public ShortCut(GS_RWElement resource,String name,StandardTextDocument memo,
			String uri, String originalURI, String version){
		super(ReasoningWebDesktop.getInstance().getRootFolder(),name,memo);
		this.resource = resource;
		this.setName(this.name);
		this.setURIs(uri, originalURI);
		this.setVersion(version);
	}
	public ShortCut(GS_RWElement resource, String name,
			StandardTextDocument memo) {
		super(ReasoningWebDesktop.getInstance().getRootFolder(),name,memo);
		this.resource = resource;
		this.setName(this.name);
		this.setURIs();
		
		//2011/10/10 kukita
		memo.setName(this.name);
	}


	@Override
	public DesktopElementView createView() {
		return new ShortCutView();
	}
	
	public void open() {
		this.resource.show();
	}
	public void setParentFolder(DeskTopFolder parent) {
		this.parent = parent;
	}
	public Element createXMLElement(Document document) {
		Element element = document.createElement(URICreator.SHORTCUT);
		element.setAttribute(GSResource.NAME,this.name);
		element.setAttribute(GSResource.URI, this.getURI());
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		element.setAttribute(GSResource.OLD_VERSION_URI, this.getOldVersionURI());
		element.setAttribute(GSResource.VERSION, this.version);
		element.setAttribute("resourceURI",this.resourceURI);
		if (this.resource != null) {
			element.appendChild(this.resource.createXMLElement(document));
		}
		element.appendChild(this.memo.createXMLElement(document));
		return element;
	}
	public void setResource(GS_RWElement resource) {
		this.resource = resource;
		if (resource != null) {
			this.resourceURI = resource.getURI();
		}
	}
	public static ShortCut restore(Element element) {
		String name = element.getAttribute(GSResource.NAME);
		String uri = element.getAttribute(GSResource.URI);
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String oldVersionURI = element.getAttribute(GSResource.OLD_VERSION_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String source = element.getAttribute("source");
		String resourceURI = element.getAttribute("resourceURI");
		ShortCut shortcut = new ShortCut();
		shortcut.setName(name);
		shortcut.setOldVersionURI(oldVersionURI);
		shortcut.setVersion(version);
		shortcut.setString(source);
		shortcut.setResourceURI(resourceURI);
		NodeList list = element.getChildNodes();
		for(int i=0;i<list.getLength();i++){
			if(list.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element elem = (Element)list.item(i);
				if(elem.getNodeName().equals("standardDocument")){
					StandardTextDocument memo = (StandardTextDocument) XML2ResourceConverter.convert(elem);
					shortcut.setMemo(memo);
				}else{
					GS_RWElement resource = XML2RWElementConverter.convert((Element)list.item(i));
					if (resource == null) {
						System.out.println("Error: specified resource is not found. Null-resource ShortCut is made for " + (Element)list.item(i));
					} else {
						shortcut.setResource(resource);
					}
				}
			}
		}
		shortcut.setURIs(uri, originalURI);
		return shortcut;
	}


	public void setResourceURI(String resourceURI) {
		this.resourceURI = resourceURI;
	}

	// TODO \łȂ̂̕\𓝈ꂹII
	public JPanel createElementViewPanel() throws NoWayToShowException {
		throw new NoWayToShowException();
	}
	
	public JPanel createElementViewPanel(int width, int height) throws NoWayToShowException {
		JPanel panel = new JPanel();
		panel.add(new JLabel("ShortCut"));
		panel.setSize(width, height);
		return panel;
	}

	public String getURI() {
		return this.uri;
	}

	public void show() {
		this.resource.show();
		
	}

	public GS_RWElement getResource() {
		return this.resource;
	}

	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getTypeString() {
		return URICreator.SHORTCUT;
	}

	@Override
	public void setURI(String uri) {
		this.uri = uri;
	}
	@Override
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}
	public void setURIs() {
		this.originalURI = URICreator.createURI(this);
		this.uri = this.originalURI;
	}


	@Override
	public String getVersion() {
		return this.version;
	}
	@Override
	public void setVersion(String version) {
		this.version = version;
	}
	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}


}
