/* $Id: LineSegmentsMenu.java 299 2011-08-11 14:23:29Z ohura $ */
package smart_gs.menu;

import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JMenu;

import smart_gs.drawing_tool.action.ChangeSizeAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.action.SaveLineSegmentsAndDscCompileAction;
import smart_gs.swingui.toolbar.action.PolygonalLineActionListener;
import smart_gs.swingui.toolbar.action.ShowLinesActionListener;

public class LineSegmentsMenu extends JMenu {

	public LineSegmentsMenu(String title, AbstractGSWindow parent){
		super(title);
		JMenuItem polygonalLine = new JMenuItem("Specify Line");
		polygonalLine.addActionListener(new PolygonalLineActionListener());
		this.add(polygonalLine);
		
		JMenuItem showLines = new JMenuItem("Show Line");
		showLines.addActionListener(new ShowLinesActionListener(parent));
		this.add(showLines);
		
		JMenuItem createDSC = new JMenuItem("Create DSC");
		createDSC.addActionListener(new SaveLineSegmentsAndDscCompileAction(parent));
		this.add(createDSC);
		
		JMenuItem changeSize = new JMenuItem("Edit Lines");
		changeSize.addActionListener (new ChangeSizeAction(parent));
		this.add(changeSize);
	}
}
