/*
 * Decompiled with CFR 0.152.
 */
package sml_editor.node;

import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import sml_editor.node.SmlBR;
import sml_editor.node.SmlChildNode;
import sml_editor.node.SmlElement;
import sml_editor.node.SmlNode;
import sml_editor.node.SmlText;

public class SmlDocument
extends SmlChildNode {
    private Document fDocument;
    private SmlElement fRoot;

    public SmlDocument(Document document) {
        this.fDocument = document;
        this.fRoot = new SmlElement(document.getDocumentElement());
    }

    @Override
    protected int calculateLength() {
        return this.fRoot.calculateLength();
    }

    @Override
    public Node getNode() {
        return this.fDocument;
    }

    public SmlElement createElement(String tagName) {
        Element elem = this.fDocument.createElement(tagName);
        return new SmlElement(elem);
    }

    public SmlText createTextNode(String data) {
        Text text = this.fDocument.createTextNode(data);
        return new SmlText(text);
    }

    public SmlBR createBRNode() {
        Element elem = this.fDocument.createElement("br");
        return new SmlBR(elem);
    }

    public SmlElement getDocumentElement() {
        return this.fRoot;
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    public SmlNode getNodeByPath(String path) {
        try {
            SmlNode node = this.fRoot;
            StringTokenizer tokens = new StringTokenizer(path, "/");
            while (tokens.hasMoreTokens()) {
                int index = Integer.parseInt(tokens.nextToken());
                node = node.getChild(index);
            }
            return node;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

